package zio.aws.s3.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{ETag, LastModified, ObjectKey}
import scala.jdk.CollectionConverters._
final case class S3Object(
    key: Optional[ObjectKey] = Optional.Absent,
    lastModified: Optional[LastModified] = Optional.Absent,
    eTag: Optional[ETag] = Optional.Absent,
    checksumAlgorithm: Optional[Iterable[zio.aws.s3.model.ChecksumAlgorithm]] =
      Optional.Absent,
    size: Optional[Long] = Optional.Absent,
    storageClass: Optional[zio.aws.s3.model.ObjectStorageClass] =
      Optional.Absent,
    owner: Optional[zio.aws.s3.model.Owner] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.S3Object = {
    import S3Object.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.S3Object
      .builder()
      .optionallyWith(
        key.map(value => ObjectKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        lastModified.map(value => LastModified.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(
        checksumAlgorithm.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.checksumAlgorithmWithStrings)
      .optionallyWith(size.map(value => value: java.lang.Long))(_.size)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.S3Object.ReadOnly =
    zio.aws.s3.model.S3Object.wrap(buildAwsValue())
}
object S3Object {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.S3Object] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.S3Object = zio.aws.s3.model.S3Object(
      key.map(value => value),
      lastModified.map(value => value),
      eTag.map(value => value),
      checksumAlgorithm.map(value => value),
      size.map(value => value),
      storageClass.map(value => value),
      owner.map(value => value.asEditable)
    )
    def key: Optional[ObjectKey]
    def lastModified: Optional[LastModified]
    def eTag: Optional[ETag]
    def checksumAlgorithm: Optional[List[zio.aws.s3.model.ChecksumAlgorithm]]
    def size: Optional[Long]
    def storageClass: Optional[zio.aws.s3.model.ObjectStorageClass]
    def owner: Optional[zio.aws.s3.model.Owner.ReadOnly]
    def getKey: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", key)
    def getLastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, List[zio.aws.s3.model.ChecksumAlgorithm]] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
    def getSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("size", size)
    def getStorageClass
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectStorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getOwner: ZIO[Any, AwsError, zio.aws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", owner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.S3Object
  ) extends zio.aws.s3.model.S3Object.ReadOnly {
    override val key: Optional[ObjectKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.s3.model.primitives.ObjectKey(value))
    override val lastModified: Optional[LastModified] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.s3.model.primitives.LastModified(value))
    override val eTag: Optional[ETag] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => zio.aws.s3.model.primitives.ETag(value))
    override val checksumAlgorithm
        : Optional[List[zio.aws.s3.model.ChecksumAlgorithm]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checksumAlgorithm())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.ChecksumAlgorithm.wrap(item)
          }.toList
        )
    override val size: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => value: Long)
    override val storageClass: Optional[zio.aws.s3.model.ObjectStorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value => zio.aws.s3.model.ObjectStorageClass.wrap(value))
    override val owner: Optional[zio.aws.s3.model.Owner.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => zio.aws.s3.model.Owner.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.S3Object
  ): zio.aws.s3.model.S3Object.ReadOnly = new Wrapper(impl)
}
