package zio.aws.s3.model
import zio.aws.s3.model.primitives.SSEKMSKeyId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SSEKMS(keyId: SSEKMSKeyId) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.SSEKMS = {
    import SSEKMS.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.SSEKMS
      .builder()
      .keyId(SSEKMSKeyId.unwrap(keyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.SSEKMS.ReadOnly =
    zio.aws.s3.model.SSEKMS.wrap(buildAwsValue())
}
object SSEKMS {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.SSEKMS] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.SSEKMS = zio.aws.s3.model.SSEKMS(keyId)
    def keyId: SSEKMSKeyId
    def getKeyId: ZIO[Any, Nothing, SSEKMSKeyId] = ZIO.succeed(keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.SSEKMS
  ) extends zio.aws.s3.model.SSEKMS.ReadOnly {
    override val keyId: SSEKMSKeyId =
      zio.aws.s3.model.primitives.SSEKMSKeyId(impl.keyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.SSEKMS
  ): zio.aws.s3.model.SSEKMS.ReadOnly = new Wrapper(impl)
}
