package zio.aws.s3.model
import zio.aws.s3.model.primitives.{End, Start}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ScanRange(
    start: Optional[Start] = Optional.Absent,
    end: Optional[End] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.ScanRange = {
    import ScanRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ScanRange
      .builder()
      .optionallyWith(start.map(value => Start.unwrap(value): java.lang.Long))(
        _.start
      )
      .optionallyWith(end.map(value => End.unwrap(value): java.lang.Long))(
        _.end
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ScanRange.ReadOnly =
    zio.aws.s3.model.ScanRange.wrap(buildAwsValue())
}
object ScanRange {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.ScanRange] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ScanRange = zio.aws.s3.model
      .ScanRange(start.map(value => value), end.map(value => value))
    def start: Optional[Start]
    def end: Optional[End]
    def getStart: ZIO[Any, AwsError, Start] =
      AwsError.unwrapOptionField("start", start)
    def getEnd: ZIO[Any, AwsError, End] = AwsError.unwrapOptionField("end", end)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ScanRange
  ) extends zio.aws.s3.model.ScanRange.ReadOnly {
    override val start: Optional[Start] = zio.aws.core.internal
      .optionalFromNullable(impl.start())
      .map(value => zio.aws.s3.model.primitives.Start(value))
    override val end: Optional[End] = zio.aws.core.internal
      .optionalFromNullable(impl.end())
      .map(value => zio.aws.s3.model.primitives.End(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ScanRange
  ): zio.aws.s3.model.ScanRange.ReadOnly = new Wrapper(impl)
}
