package zio.aws.s3.model
import zio.aws.s3.model.primitives.Expression
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SelectParameters(
    inputSerialization: zio.aws.s3.model.InputSerialization,
    expressionType: zio.aws.s3.model.ExpressionType,
    expression: Expression,
    outputSerialization: zio.aws.s3.model.OutputSerialization
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.SelectParameters = {
    import SelectParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.SelectParameters
      .builder()
      .inputSerialization(inputSerialization.buildAwsValue())
      .expressionType(expressionType.unwrap)
      .expression(Expression.unwrap(expression): java.lang.String)
      .outputSerialization(outputSerialization.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.s3.model.SelectParameters.ReadOnly =
    zio.aws.s3.model.SelectParameters.wrap(buildAwsValue())
}
object SelectParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.SelectParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.SelectParameters =
      zio.aws.s3.model.SelectParameters(
        inputSerialization.asEditable,
        expressionType,
        expression,
        outputSerialization.asEditable
      )
    def inputSerialization: zio.aws.s3.model.InputSerialization.ReadOnly
    def expressionType: zio.aws.s3.model.ExpressionType
    def expression: Expression
    def outputSerialization: zio.aws.s3.model.OutputSerialization.ReadOnly
    def getInputSerialization
        : ZIO[Any, Nothing, zio.aws.s3.model.InputSerialization.ReadOnly] =
      ZIO.succeed(inputSerialization)
    def getExpressionType: ZIO[Any, Nothing, zio.aws.s3.model.ExpressionType] =
      ZIO.succeed(expressionType)
    def getExpression: ZIO[Any, Nothing, Expression] = ZIO.succeed(expression)
    def getOutputSerialization
        : ZIO[Any, Nothing, zio.aws.s3.model.OutputSerialization.ReadOnly] =
      ZIO.succeed(outputSerialization)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.SelectParameters
  ) extends zio.aws.s3.model.SelectParameters.ReadOnly {
    override val inputSerialization
        : zio.aws.s3.model.InputSerialization.ReadOnly =
      zio.aws.s3.model.InputSerialization.wrap(impl.inputSerialization())
    override val expressionType: zio.aws.s3.model.ExpressionType =
      zio.aws.s3.model.ExpressionType.wrap(impl.expressionType())
    override val expression: Expression =
      zio.aws.s3.model.primitives.Expression(impl.expression())
    override val outputSerialization
        : zio.aws.s3.model.OutputSerialization.ReadOnly =
      zio.aws.s3.model.OutputSerialization.wrap(impl.outputSerialization())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.SelectParameters
  ): zio.aws.s3.model.SelectParameters.ReadOnly = new Wrapper(impl)
}
