package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SourceSelectionCriteria(
    sseKmsEncryptedObjects: Optional[zio.aws.s3.model.SseKmsEncryptedObjects] =
      Optional.Absent,
    replicaModifications: Optional[zio.aws.s3.model.ReplicaModifications] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.SourceSelectionCriteria = {
    import SourceSelectionCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.SourceSelectionCriteria
      .builder()
      .optionallyWith(
        sseKmsEncryptedObjects.map(value => value.buildAwsValue())
      )(_.sseKmsEncryptedObjects)
      .optionallyWith(replicaModifications.map(value => value.buildAwsValue()))(
        _.replicaModifications
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.SourceSelectionCriteria.ReadOnly =
    zio.aws.s3.model.SourceSelectionCriteria.wrap(buildAwsValue())
}
object SourceSelectionCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.SourceSelectionCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.SourceSelectionCriteria =
      zio.aws.s3.model.SourceSelectionCriteria(
        sseKmsEncryptedObjects.map(value => value.asEditable),
        replicaModifications.map(value => value.asEditable)
      )
    def sseKmsEncryptedObjects
        : Optional[zio.aws.s3.model.SseKmsEncryptedObjects.ReadOnly]
    def replicaModifications
        : Optional[zio.aws.s3.model.ReplicaModifications.ReadOnly]
    def getSseKmsEncryptedObjects
        : ZIO[Any, AwsError, zio.aws.s3.model.SseKmsEncryptedObjects.ReadOnly] =
      AwsError.unwrapOptionField(
        "sseKmsEncryptedObjects",
        sseKmsEncryptedObjects
      )
    def getReplicaModifications
        : ZIO[Any, AwsError, zio.aws.s3.model.ReplicaModifications.ReadOnly] =
      AwsError.unwrapOptionField("replicaModifications", replicaModifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.SourceSelectionCriteria
  ) extends zio.aws.s3.model.SourceSelectionCriteria.ReadOnly {
    override val sseKmsEncryptedObjects
        : Optional[zio.aws.s3.model.SseKmsEncryptedObjects.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseKmsEncryptedObjects())
        .map(value => zio.aws.s3.model.SseKmsEncryptedObjects.wrap(value))
    override val replicaModifications
        : Optional[zio.aws.s3.model.ReplicaModifications.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicaModifications())
        .map(value => zio.aws.s3.model.ReplicaModifications.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.SourceSelectionCriteria
  ): zio.aws.s3.model.SourceSelectionCriteria.ReadOnly = new Wrapper(impl)
}
