package zio.aws.s3.model
import java.lang.Integer
import zio.aws.s3.model.primitives.IntelligentTieringDays
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Tiering(
    days: IntelligentTieringDays,
    accessTier: zio.aws.s3.model.IntelligentTieringAccessTier
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Tiering = {
    import Tiering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Tiering
      .builder()
      .days(IntelligentTieringDays.unwrap(days): Integer)
      .accessTier(accessTier.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.Tiering.ReadOnly =
    zio.aws.s3.model.Tiering.wrap(buildAwsValue())
}
object Tiering {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Tiering] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.Tiering =
      zio.aws.s3.model.Tiering(days, accessTier)
    def days: IntelligentTieringDays
    def accessTier: zio.aws.s3.model.IntelligentTieringAccessTier
    def getDays: ZIO[Any, Nothing, IntelligentTieringDays] = ZIO.succeed(days)
    def getAccessTier
        : ZIO[Any, Nothing, zio.aws.s3.model.IntelligentTieringAccessTier] =
      ZIO.succeed(accessTier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Tiering
  ) extends zio.aws.s3.model.Tiering.ReadOnly {
    override val days: IntelligentTieringDays =
      zio.aws.s3.model.primitives.IntelligentTieringDays(impl.days())
    override val accessTier: zio.aws.s3.model.IntelligentTieringAccessTier =
      zio.aws.s3.model.IntelligentTieringAccessTier.wrap(impl.accessTier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Tiering
  ): zio.aws.s3.model.Tiering.ReadOnly = new Wrapper(impl)
}
