package zio.aws.s3.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  SSECustomerKey,
  CopySourceSSECustomerKeyMD5,
  CopySourceSSECustomerAlgorithm,
  AccountId,
  CopySourceRange,
  SSECustomerAlgorithm,
  CopySourceIfUnmodifiedSince,
  SSECustomerKeyMD5,
  CopySourceIfMatch,
  ObjectKey,
  BucketName,
  CopySourceSSECustomerKey,
  CopySourceIfNoneMatch,
  CopySourceIfModifiedSince,
  PartNumber,
  CopySource,
  MultipartUploadId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UploadPartCopyRequest(
    destinationBucket: BucketName,
    copySource: CopySource,
    copySourceIfMatch: Optional[CopySourceIfMatch] = Optional.Absent,
    copySourceIfModifiedSince: Optional[CopySourceIfModifiedSince] =
      Optional.Absent,
    copySourceIfNoneMatch: Optional[CopySourceIfNoneMatch] = Optional.Absent,
    copySourceIfUnmodifiedSince: Optional[CopySourceIfUnmodifiedSince] =
      Optional.Absent,
    copySourceRange: Optional[CopySourceRange] = Optional.Absent,
    destinationKey: ObjectKey,
    partNumber: PartNumber,
    uploadId: MultipartUploadId,
    sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] = Optional.Absent,
    sseCustomerKey: Optional[SSECustomerKey] = Optional.Absent,
    sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] = Optional.Absent,
    copySourceSSECustomerAlgorithm: Optional[CopySourceSSECustomerAlgorithm] =
      Optional.Absent,
    copySourceSSECustomerKey: Optional[CopySourceSSECustomerKey] =
      Optional.Absent,
    copySourceSSECustomerKeyMD5: Optional[CopySourceSSECustomerKeyMD5] =
      Optional.Absent,
    requestPayer: Optional[zio.aws.s3.model.RequestPayer] = Optional.Absent,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent,
    expectedSourceBucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.UploadPartCopyRequest = {
    import UploadPartCopyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.UploadPartCopyRequest
      .builder()
      .destinationBucket(BucketName.unwrap(destinationBucket): java.lang.String)
      .copySource(CopySource.unwrap(copySource): java.lang.String)
      .optionallyWith(
        copySourceIfMatch.map(value =>
          CopySourceIfMatch.unwrap(value): java.lang.String
        )
      )(_.copySourceIfMatch)
      .optionallyWith(
        copySourceIfModifiedSince.map(value =>
          CopySourceIfModifiedSince.unwrap(value): Instant
        )
      )(_.copySourceIfModifiedSince)
      .optionallyWith(
        copySourceIfNoneMatch.map(value =>
          CopySourceIfNoneMatch.unwrap(value): java.lang.String
        )
      )(_.copySourceIfNoneMatch)
      .optionallyWith(
        copySourceIfUnmodifiedSince.map(value =>
          CopySourceIfUnmodifiedSince.unwrap(value): Instant
        )
      )(_.copySourceIfUnmodifiedSince)
      .optionallyWith(
        copySourceRange.map(value =>
          CopySourceRange.unwrap(value): java.lang.String
        )
      )(_.copySourceRange)
      .destinationKey(ObjectKey.unwrap(destinationKey): java.lang.String)
      .partNumber(PartNumber.unwrap(partNumber): Integer)
      .uploadId(MultipartUploadId.unwrap(uploadId): java.lang.String)
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKey.map(value =>
          SSECustomerKey.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKey)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(
        copySourceSSECustomerAlgorithm.map(value =>
          CopySourceSSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.copySourceSSECustomerAlgorithm)
      .optionallyWith(
        copySourceSSECustomerKey.map(value =>
          CopySourceSSECustomerKey.unwrap(value): java.lang.String
        )
      )(_.copySourceSSECustomerKey)
      .optionallyWith(
        copySourceSSECustomerKeyMD5.map(value =>
          CopySourceSSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.copySourceSSECustomerKeyMD5)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .optionallyWith(
        expectedSourceBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedSourceBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.UploadPartCopyRequest.ReadOnly =
    zio.aws.s3.model.UploadPartCopyRequest.wrap(buildAwsValue())
}
object UploadPartCopyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.UploadPartCopyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.UploadPartCopyRequest =
      zio.aws.s3.model.UploadPartCopyRequest(
        destinationBucket,
        copySource,
        copySourceIfMatch.map(value => value),
        copySourceIfModifiedSince.map(value => value),
        copySourceIfNoneMatch.map(value => value),
        copySourceIfUnmodifiedSince.map(value => value),
        copySourceRange.map(value => value),
        destinationKey,
        partNumber,
        uploadId,
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKey.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        copySourceSSECustomerAlgorithm.map(value => value),
        copySourceSSECustomerKey.map(value => value),
        copySourceSSECustomerKeyMD5.map(value => value),
        requestPayer.map(value => value),
        expectedBucketOwner.map(value => value),
        expectedSourceBucketOwner.map(value => value)
      )
    def destinationBucket: BucketName
    def copySource: CopySource
    def copySourceIfMatch: Optional[CopySourceIfMatch]
    def copySourceIfModifiedSince: Optional[CopySourceIfModifiedSince]
    def copySourceIfNoneMatch: Optional[CopySourceIfNoneMatch]
    def copySourceIfUnmodifiedSince: Optional[CopySourceIfUnmodifiedSince]
    def copySourceRange: Optional[CopySourceRange]
    def destinationKey: ObjectKey
    def partNumber: PartNumber
    def uploadId: MultipartUploadId
    def sseCustomerAlgorithm: Optional[SSECustomerAlgorithm]
    def sseCustomerKey: Optional[SSECustomerKey]
    def sseCustomerKeyMD5: Optional[SSECustomerKeyMD5]
    def copySourceSSECustomerAlgorithm: Optional[CopySourceSSECustomerAlgorithm]
    def copySourceSSECustomerKey: Optional[CopySourceSSECustomerKey]
    def copySourceSSECustomerKeyMD5: Optional[CopySourceSSECustomerKeyMD5]
    def requestPayer: Optional[zio.aws.s3.model.RequestPayer]
    def expectedBucketOwner: Optional[AccountId]
    def expectedSourceBucketOwner: Optional[AccountId]
    def getDestinationBucket: ZIO[Any, Nothing, BucketName] =
      ZIO.succeed(destinationBucket)
    def getCopySource: ZIO[Any, Nothing, CopySource] = ZIO.succeed(copySource)
    def getCopySourceIfMatch: ZIO[Any, AwsError, CopySourceIfMatch] =
      AwsError.unwrapOptionField("copySourceIfMatch", copySourceIfMatch)
    def getCopySourceIfModifiedSince
        : ZIO[Any, AwsError, CopySourceIfModifiedSince] = AwsError
      .unwrapOptionField("copySourceIfModifiedSince", copySourceIfModifiedSince)
    def getCopySourceIfNoneMatch: ZIO[Any, AwsError, CopySourceIfNoneMatch] =
      AwsError.unwrapOptionField("copySourceIfNoneMatch", copySourceIfNoneMatch)
    def getCopySourceIfUnmodifiedSince
        : ZIO[Any, AwsError, CopySourceIfUnmodifiedSince] =
      AwsError.unwrapOptionField(
        "copySourceIfUnmodifiedSince",
        copySourceIfUnmodifiedSince
      )
    def getCopySourceRange: ZIO[Any, AwsError, CopySourceRange] =
      AwsError.unwrapOptionField("copySourceRange", copySourceRange)
    def getDestinationKey: ZIO[Any, Nothing, ObjectKey] =
      ZIO.succeed(destinationKey)
    def getPartNumber: ZIO[Any, Nothing, PartNumber] = ZIO.succeed(partNumber)
    def getUploadId: ZIO[Any, Nothing, MultipartUploadId] =
      ZIO.succeed(uploadId)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKey)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getCopySourceSSECustomerAlgorithm
        : ZIO[Any, AwsError, CopySourceSSECustomerAlgorithm] =
      AwsError.unwrapOptionField(
        "copySourceSSECustomerAlgorithm",
        copySourceSSECustomerAlgorithm
      )
    def getCopySourceSSECustomerKey
        : ZIO[Any, AwsError, CopySourceSSECustomerKey] = AwsError
      .unwrapOptionField("copySourceSSECustomerKey", copySourceSSECustomerKey)
    def getCopySourceSSECustomerKeyMD5
        : ZIO[Any, AwsError, CopySourceSSECustomerKeyMD5] =
      AwsError.unwrapOptionField(
        "copySourceSSECustomerKeyMD5",
        copySourceSSECustomerKeyMD5
      )
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getExpectedSourceBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedSourceBucketOwner", expectedSourceBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.UploadPartCopyRequest
  ) extends zio.aws.s3.model.UploadPartCopyRequest.ReadOnly {
    override val destinationBucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.destinationBucket())
    override val copySource: CopySource =
      zio.aws.s3.model.primitives.CopySource(impl.copySource())
    override val copySourceIfMatch: Optional[CopySourceIfMatch] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copySourceIfMatch())
        .map(value => zio.aws.s3.model.primitives.CopySourceIfMatch(value))
    override val copySourceIfModifiedSince
        : Optional[CopySourceIfModifiedSince] = zio.aws.core.internal
      .optionalFromNullable(impl.copySourceIfModifiedSince())
      .map(value =>
        zio.aws.s3.model.primitives.CopySourceIfModifiedSince(value)
      )
    override val copySourceIfNoneMatch: Optional[CopySourceIfNoneMatch] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copySourceIfNoneMatch())
        .map(value => zio.aws.s3.model.primitives.CopySourceIfNoneMatch(value))
    override val copySourceIfUnmodifiedSince
        : Optional[CopySourceIfUnmodifiedSince] = zio.aws.core.internal
      .optionalFromNullable(impl.copySourceIfUnmodifiedSince())
      .map(value =>
        zio.aws.s3.model.primitives.CopySourceIfUnmodifiedSince(value)
      )
    override val copySourceRange: Optional[CopySourceRange] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copySourceRange())
        .map(value => zio.aws.s3.model.primitives.CopySourceRange(value))
    override val destinationKey: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.destinationKey())
    override val partNumber: PartNumber =
      zio.aws.s3.model.primitives.PartNumber(impl.partNumber())
    override val uploadId: MultipartUploadId =
      zio.aws.s3.model.primitives.MultipartUploadId(impl.uploadId())
    override val sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerAlgorithm())
        .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKey: Optional[SSECustomerKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKey())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKey(value))
    override val sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKeyMD5())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val copySourceSSECustomerAlgorithm
        : Optional[CopySourceSSECustomerAlgorithm] = zio.aws.core.internal
      .optionalFromNullable(impl.copySourceSSECustomerAlgorithm())
      .map(value =>
        zio.aws.s3.model.primitives.CopySourceSSECustomerAlgorithm(value)
      )
    override val copySourceSSECustomerKey: Optional[CopySourceSSECustomerKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copySourceSSECustomerKey())
        .map(value =>
          zio.aws.s3.model.primitives.CopySourceSSECustomerKey(value)
        )
    override val copySourceSSECustomerKeyMD5
        : Optional[CopySourceSSECustomerKeyMD5] = zio.aws.core.internal
      .optionalFromNullable(impl.copySourceSSECustomerKeyMD5())
      .map(value =>
        zio.aws.s3.model.primitives.CopySourceSSECustomerKeyMD5(value)
      )
    override val requestPayer: Optional[zio.aws.s3.model.RequestPayer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestPayer())
        .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
    override val expectedSourceBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedSourceBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.UploadPartCopyRequest
  ): zio.aws.s3.model.UploadPartCopyRequest.ReadOnly = new Wrapper(impl)
}
