package zio.aws.s3
import zio.aws.s3.model.PutObjectLockConfigurationResponse.ReadOnly
import software.amazon.awssdk.services.s3.paginators.{
  ListObjectsV2Publisher,
  ListPartsPublisher,
  ListMultipartUploadsPublisher,
  ListObjectVersionsPublisher
}
import zio.aws.core.config.AwsConfig
import zio.aws.s3.model.{
  PutBucketWebsiteRequest,
  PutBucketPolicyRequest,
  RestoreObjectRequest,
  DeleteObjectTaggingRequest,
  ListObjectsRequest,
  GetBucketLoggingRequest,
  PutObjectRetentionRequest,
  GetBucketVersioningRequest,
  GetBucketEncryptionRequest,
  GetBucketNotificationConfigurationRequest,
  DeleteBucketReplicationRequest,
  PutBucketLifecycleConfigurationRequest,
  DeleteBucketIntelligentTieringConfigurationRequest,
  HeadBucketRequest,
  GetBucketAclRequest,
  DeleteObjectsRequest,
  PutBucketVersioningRequest,
  PutBucketAnalyticsConfigurationRequest,
  GetBucketReplicationRequest,
  GetBucketPolicyRequest,
  WriteGetObjectResponseRequest,
  SelectObjectContentRequest,
  PutBucketNotificationConfigurationRequest,
  DeleteBucketTaggingRequest,
  PutBucketEncryptionRequest,
  PutBucketAclRequest,
  GetBucketOwnershipControlsRequest,
  DeleteBucketAnalyticsConfigurationRequest,
  PutBucketInventoryConfigurationRequest,
  GetBucketLocationRequest,
  ListBucketIntelligentTieringConfigurationsRequest,
  GetObjectRetentionRequest,
  GetBucketCorsRequest,
  PutObjectTaggingRequest,
  AbortMultipartUploadRequest,
  UploadPartCopyRequest,
  HeadObjectRequest,
  PutObjectRequest,
  PutPublicAccessBlockRequest,
  GetBucketTaggingRequest,
  GetBucketWebsiteRequest,
  GetBucketInventoryConfigurationRequest,
  DeleteBucketLifecycleRequest,
  ListBucketMetricsConfigurationsRequest,
  PutBucketReplicationRequest,
  ListMultipartUploadsRequest,
  GetPublicAccessBlockRequest,
  DeletePublicAccessBlockRequest,
  PutBucketCorsRequest,
  UploadPartRequest,
  ListBucketInventoryConfigurationsRequest,
  GetBucketIntelligentTieringConfigurationRequest,
  GetBucketPolicyStatusRequest,
  PutBucketIntelligentTieringConfigurationRequest,
  GetBucketLifecycleConfigurationRequest,
  DeleteBucketInventoryConfigurationRequest,
  GetBucketRequestPaymentRequest,
  PutBucketAccelerateConfigurationRequest,
  DeleteBucketRequest,
  PutBucketOwnershipControlsRequest,
  PutObjectLegalHoldRequest,
  DeleteBucketWebsiteRequest,
  GetObjectRequest,
  GetObjectTaggingRequest,
  CopyObjectRequest,
  DeleteBucketEncryptionRequest,
  CompleteMultipartUploadRequest,
  DeleteBucketOwnershipControlsRequest,
  PutObjectAclRequest,
  CreateBucketRequest,
  ListObjectVersionsRequest,
  GetBucketMetricsConfigurationRequest,
  ListBucketAnalyticsConfigurationsRequest,
  DeleteBucketCorsRequest,
  GetObjectAclRequest,
  DeleteBucketPolicyRequest,
  GetObjectLegalHoldRequest,
  ListPartsRequest,
  CreateMultipartUploadRequest,
  PutBucketTaggingRequest,
  GetObjectTorrentRequest,
  PutObjectLockConfigurationRequest,
  DeleteObjectRequest,
  GetObjectAttributesRequest,
  GetObjectLockConfigurationRequest,
  GetBucketAnalyticsConfigurationRequest,
  PutBucketLoggingRequest,
  GetBucketAccelerateConfigurationRequest,
  PutBucketMetricsConfigurationRequest,
  PutBucketRequestPaymentRequest,
  DeleteBucketMetricsConfigurationRequest,
  ListObjectsV2Request
}
import software.amazon.awssdk.services.s3.{S3AsyncClientBuilder, S3AsyncClient}
import software.amazon.awssdk.services.s3.model.{
  PutBucketTaggingResponse,
  PutBucketLifecycleConfigurationResponse,
  PutBucketAccelerateConfigurationResponse,
  DeleteBucketIntelligentTieringConfigurationResponse,
  DeleteBucketEncryptionResponse,
  PutBucketLoggingResponse,
  DeleteBucketOwnershipControlsResponse,
  SelectObjectContentResponseHandler,
  GetObjectLockConfigurationResponse,
  PutBucketWebsiteResponse,
  UploadPartResponse,
  ListObjectsV2Response,
  PutBucketNotificationConfigurationResponse,
  GetObjectResponse,
  PutBucketRequestPaymentResponse,
  ListBucketMetricsConfigurationsResponse,
  GetBucketLifecycleConfigurationResponse,
  GetPublicAccessBlockResponse,
  PutBucketCorsResponse,
  DeleteObjectsResponse,
  HeadBucketResponse,
  SelectObjectContentEventStream,
  HeadObjectResponse,
  PutPublicAccessBlockResponse,
  RestoreObjectResponse,
  GetBucketOwnershipControlsResponse,
  DeletePublicAccessBlockResponse,
  PutBucketIntelligentTieringConfigurationResponse,
  PutObjectTaggingResponse,
  DeleteBucketReplicationResponse,
  GetBucketTaggingResponse,
  GetBucketInventoryConfigurationResponse,
  PutObjectLockConfigurationResponse,
  GetBucketCorsResponse,
  ObjectVersion,
  DeleteObjectResponse,
  GetBucketPolicyResponse,
  UploadPartCopyResponse,
  ListPartsResponse,
  ListBucketsRequest,
  DeleteBucketCorsResponse,
  DeleteBucketLifecycleResponse,
  GetBucketNotificationConfigurationResponse,
  CreateBucketResponse,
  DeleteBucketResponse,
  DeleteObjectTaggingResponse,
  DeleteBucketTaggingResponse,
  DeleteBucketMetricsConfigurationResponse,
  PutObjectRetentionResponse,
  ListObjectsResponse,
  DeleteBucketPolicyResponse,
  ListBucketAnalyticsConfigurationsResponse,
  PutObjectLegalHoldResponse,
  PutObjectResponse,
  DeleteBucketInventoryConfigurationResponse,
  GetObjectAclResponse,
  RecordsEvent,
  SelectObjectContentResponse,
  PutBucketVersioningResponse,
  WriteGetObjectResponseResponse,
  PutBucketPolicyResponse,
  Part,
  PutBucketInventoryConfigurationResponse,
  GetObjectRetentionResponse,
  GetBucketPolicyStatusResponse,
  GetObjectTorrentResponse,
  GetBucketAccelerateConfigurationResponse,
  GetBucketAnalyticsConfigurationResponse,
  ListBucketInventoryConfigurationsResponse,
  GetBucketReplicationResponse,
  DeleteBucketWebsiteResponse,
  GetBucketIntelligentTieringConfigurationResponse,
  GetBucketRequestPaymentResponse,
  DeleteBucketAnalyticsConfigurationResponse,
  GetObjectTaggingResponse,
  ListObjectVersionsResponse,
  GetObjectAttributesResponse,
  PutBucketOwnershipControlsResponse,
  PutBucketAclResponse,
  GetBucketAclResponse,
  GetBucketVersioningResponse,
  PutBucketReplicationResponse,
  PutBucketAnalyticsConfigurationResponse,
  AbortMultipartUploadResponse,
  ListBucketsResponse,
  ListBucketIntelligentTieringConfigurationsResponse,
  CopyObjectResponse,
  GetBucketMetricsConfigurationResponse,
  CreateMultipartUploadResponse,
  GetBucketLoggingResponse,
  PutBucketMetricsConfigurationResponse,
  CompleteMultipartUploadResponse,
  PutObjectAclResponse,
  GetObjectLegalHoldResponse,
  GetBucketEncryptionResponse,
  ListMultipartUploadsResponse,
  GetBucketWebsiteResponse,
  GetBucketLocationResponse,
  S3Object,
  PutBucketEncryptionResponse,
  MultipartUpload
}
import software.amazon.awssdk.core.async.SdkPublisher
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, Task, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.awscore.eventstream.EventStreamResponseHandler
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait S3 extends AspectSupport[S3] {
  val api: S3AsyncClient
  def uploadPart(
      request: UploadPartRequest,
      body: ZStream[Any, AwsError, Byte]
  ): IO[AwsError, zio.aws.s3.model.UploadPartResponse.ReadOnly]
  def createMultipartUpload(
      request: CreateMultipartUploadRequest
  ): IO[AwsError, zio.aws.s3.model.CreateMultipartUploadResponse.ReadOnly]
  def putBucketPolicy(request: PutBucketPolicyRequest): IO[AwsError, Unit]
  def getBucketPolicy(
      request: GetBucketPolicyRequest
  ): IO[AwsError, zio.aws.s3.model.GetBucketPolicyResponse.ReadOnly]
  def putBucketIntelligentTieringConfiguration(
      request: PutBucketIntelligentTieringConfigurationRequest
  ): IO[AwsError, Unit]
  def restoreObject(
      request: RestoreObjectRequest
  ): IO[AwsError, zio.aws.s3.model.RestoreObjectResponse.ReadOnly]
  def deleteBucketWebsite(
      request: DeleteBucketWebsiteRequest
  ): IO[AwsError, Unit]
  def putBucketLifecycleConfiguration(
      request: PutBucketLifecycleConfigurationRequest
  ): IO[AwsError, Unit]
  def listObjectVersions(
      request: ListObjectVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.s3.model.ObjectVersion.ReadOnly]
  def listObjectVersionsPaginated(
      request: ListObjectVersionsRequest
  ): IO[AwsError, zio.aws.s3.model.ListObjectVersionsResponse.ReadOnly]
  def putBucketLogging(request: PutBucketLoggingRequest): IO[AwsError, Unit]
  def deleteBucketPolicy(request: DeleteBucketPolicyRequest): IO[AwsError, Unit]
  def putBucketAnalyticsConfiguration(
      request: PutBucketAnalyticsConfigurationRequest
  ): IO[AwsError, Unit]
  def deleteBucketInventoryConfiguration(
      request: DeleteBucketInventoryConfigurationRequest
  ): IO[AwsError, Unit]
  def getBucketAnalyticsConfiguration(
      request: GetBucketAnalyticsConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.s3.model.GetBucketAnalyticsConfigurationResponse.ReadOnly
  ]
  def putObjectAcl(
      request: PutObjectAclRequest
  ): IO[AwsError, zio.aws.s3.model.PutObjectAclResponse.ReadOnly]
  def listBucketAnalyticsConfigurations(
      request: ListBucketAnalyticsConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.s3.model.ListBucketAnalyticsConfigurationsResponse.ReadOnly
  ]
  def deleteBucketLifecycle(
      request: DeleteBucketLifecycleRequest
  ): IO[AwsError, Unit]
  def getObjectAcl(
      request: GetObjectAclRequest
  ): IO[AwsError, zio.aws.s3.model.GetObjectAclResponse.ReadOnly]
  def listBucketInventoryConfigurations(
      request: ListBucketInventoryConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.s3.model.ListBucketInventoryConfigurationsResponse.ReadOnly
  ]
  def listMultipartUploads(
      request: ListMultipartUploadsRequest
  ): ZStream[Any, AwsError, zio.aws.s3.model.MultipartUpload.ReadOnly]
  def listMultipartUploadsPaginated(
      request: ListMultipartUploadsRequest
  ): IO[AwsError, zio.aws.s3.model.ListMultipartUploadsResponse.ReadOnly]
  def getBucketLifecycleConfiguration(
      request: GetBucketLifecycleConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.s3.model.GetBucketLifecycleConfigurationResponse.ReadOnly
  ]
  def getBucketEncryption(
      request: GetBucketEncryptionRequest
  ): IO[AwsError, zio.aws.s3.model.GetBucketEncryptionResponse.ReadOnly]
  def writeGetObjectResponse(
      request: WriteGetObjectResponseRequest,
      body: ZStream[Any, AwsError, Byte]
  ): IO[AwsError, Unit]
  def getBucketCors(
      request: GetBucketCorsRequest
  ): IO[AwsError, zio.aws.s3.model.GetBucketCorsResponse.ReadOnly]
  def getObjectRetention(
      request: GetObjectRetentionRequest
  ): IO[AwsError, zio.aws.s3.model.GetObjectRetentionResponse.ReadOnly]
  def getBucketLogging(
      request: GetBucketLoggingRequest
  ): IO[AwsError, zio.aws.s3.model.GetBucketLoggingResponse.ReadOnly]
  def listParts(
      request: ListPartsRequest
  ): ZStream[Any, AwsError, zio.aws.s3.model.Part.ReadOnly]
  def listPartsPaginated(
      request: ListPartsRequest
  ): IO[AwsError, zio.aws.s3.model.ListPartsResponse.ReadOnly]
  def getObjectAttributes(
      request: GetObjectAttributesRequest
  ): IO[AwsError, zio.aws.s3.model.GetObjectAttributesResponse.ReadOnly]
  def listBucketIntelligentTieringConfigurations(
      request: ListBucketIntelligentTieringConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.s3.model.ListBucketIntelligentTieringConfigurationsResponse.ReadOnly
  ]
  def listBucketMetricsConfigurations(
      request: ListBucketMetricsConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.s3.model.ListBucketMetricsConfigurationsResponse.ReadOnly
  ]
  def putBucketMetricsConfiguration(
      request: PutBucketMetricsConfigurationRequest
  ): IO[AwsError, Unit]
  def deleteBucketAnalyticsConfiguration(
      request: DeleteBucketAnalyticsConfigurationRequest
  ): IO[AwsError, Unit]
  def deleteBucketReplication(
      request: DeleteBucketReplicationRequest
  ): IO[AwsError, Unit]
  def uploadPartCopy(
      request: UploadPartCopyRequest
  ): IO[AwsError, zio.aws.s3.model.UploadPartCopyResponse.ReadOnly]
  def getObjectLegalHold(
      request: GetObjectLegalHoldRequest
  ): IO[AwsError, zio.aws.s3.model.GetObjectLegalHoldResponse.ReadOnly]
  def getBucketRequestPayment(
      request: GetBucketRequestPaymentRequest
  ): IO[AwsError, zio.aws.s3.model.GetBucketRequestPaymentResponse.ReadOnly]
  def getBucketMetricsConfiguration(
      request: GetBucketMetricsConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.s3.model.GetBucketMetricsConfigurationResponse.ReadOnly
  ]
  def copyObject(
      request: CopyObjectRequest
  ): IO[AwsError, zio.aws.s3.model.CopyObjectResponse.ReadOnly]
  def putBucketWebsite(request: PutBucketWebsiteRequest): IO[AwsError, Unit]
  def getBucketAccelerateConfiguration(
      request: GetBucketAccelerateConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.s3.model.GetBucketAccelerateConfigurationResponse.ReadOnly
  ]
  def headBucket(request: HeadBucketRequest): IO[AwsError, Unit]
  def deleteObject(
      request: DeleteObjectRequest
  ): IO[AwsError, zio.aws.s3.model.DeleteObjectResponse.ReadOnly]
  def getBucketOwnershipControls(
      request: GetBucketOwnershipControlsRequest
  ): IO[AwsError, zio.aws.s3.model.GetBucketOwnershipControlsResponse.ReadOnly]
  def putBucketReplication(
      request: PutBucketReplicationRequest
  ): IO[AwsError, Unit]
  def deleteBucket(request: DeleteBucketRequest): IO[AwsError, Unit]
  def putBucketNotificationConfiguration(
      request: PutBucketNotificationConfigurationRequest
  ): IO[AwsError, Unit]
  def deleteBucketMetricsConfiguration(
      request: DeleteBucketMetricsConfigurationRequest
  ): IO[AwsError, Unit]
  def createBucket(
      request: CreateBucketRequest
  ): IO[AwsError, zio.aws.s3.model.CreateBucketResponse.ReadOnly]
  def listObjects(
      request: ListObjectsRequest
  ): IO[AwsError, zio.aws.s3.model.ListObjectsResponse.ReadOnly]
  def listBuckets(): IO[AwsError, zio.aws.s3.model.ListBucketsResponse.ReadOnly]
  def getBucketTagging(
      request: GetBucketTaggingRequest
  ): IO[AwsError, zio.aws.s3.model.GetBucketTaggingResponse.ReadOnly]
  def putObject(
      request: PutObjectRequest,
      body: ZStream[Any, AwsError, Byte]
  ): IO[AwsError, zio.aws.s3.model.PutObjectResponse.ReadOnly]
  def putBucketTagging(request: PutBucketTaggingRequest): IO[AwsError, Unit]
  def deleteBucketTagging(
      request: DeleteBucketTaggingRequest
  ): IO[AwsError, Unit]
  def putBucketEncryption(
      request: PutBucketEncryptionRequest
  ): IO[AwsError, Unit]
  def putBucketRequestPayment(
      request: PutBucketRequestPaymentRequest
  ): IO[AwsError, Unit]
  def getObject(request: GetObjectRequest): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.s3.model.GetObjectResponse.ReadOnly,
    Byte
  ]]
  def putObjectTagging(
      request: PutObjectTaggingRequest
  ): IO[AwsError, zio.aws.s3.model.PutObjectTaggingResponse.ReadOnly]
  def deleteBucketCors(request: DeleteBucketCorsRequest): IO[AwsError, Unit]
  def putPublicAccessBlock(
      request: PutPublicAccessBlockRequest
  ): IO[AwsError, Unit]
  def getObjectTorrent(
      request: GetObjectTorrentRequest
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.s3.model.GetObjectTorrentResponse.ReadOnly,
    Byte
  ]]
  def getBucketInventoryConfiguration(
      request: GetBucketInventoryConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.s3.model.GetBucketInventoryConfigurationResponse.ReadOnly
  ]
  def getBucketVersioning(
      request: GetBucketVersioningRequest
  ): IO[AwsError, zio.aws.s3.model.GetBucketVersioningResponse.ReadOnly]
  def putBucketOwnershipControls(
      request: PutBucketOwnershipControlsRequest
  ): IO[AwsError, Unit]
  def headObject(
      request: HeadObjectRequest
  ): IO[AwsError, zio.aws.s3.model.HeadObjectResponse.ReadOnly]
  def selectObjectContent(
      request: SelectObjectContentRequest
  ): ZStream[Any, AwsError, zio.aws.s3.model.RecordsEvent.ReadOnly]
  def getBucketWebsite(
      request: GetBucketWebsiteRequest
  ): IO[AwsError, zio.aws.s3.model.GetBucketWebsiteResponse.ReadOnly]
  def deleteBucketIntelligentTieringConfiguration(
      request: DeleteBucketIntelligentTieringConfigurationRequest
  ): IO[AwsError, Unit]
  def putBucketInventoryConfiguration(
      request: PutBucketInventoryConfigurationRequest
  ): IO[AwsError, Unit]
  def getBucketIntelligentTieringConfiguration(
      request: GetBucketIntelligentTieringConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.s3.model.GetBucketIntelligentTieringConfigurationResponse.ReadOnly
  ]
  def getBucketAcl(
      request: GetBucketAclRequest
  ): IO[AwsError, zio.aws.s3.model.GetBucketAclResponse.ReadOnly]
  def listObjectsV2(
      request: ListObjectsV2Request
  ): ZStream[Any, AwsError, zio.aws.s3.model.S3Object.ReadOnly]
  def listObjectsV2Paginated(
      request: ListObjectsV2Request
  ): IO[AwsError, zio.aws.s3.model.ListObjectsV2Response.ReadOnly]
  def putBucketVersioning(
      request: PutBucketVersioningRequest
  ): IO[AwsError, Unit]
  def putBucketAcl(request: PutBucketAclRequest): IO[AwsError, Unit]
  def getBucketReplication(
      request: GetBucketReplicationRequest
  ): IO[AwsError, zio.aws.s3.model.GetBucketReplicationResponse.ReadOnly]
  def getPublicAccessBlock(
      request: GetPublicAccessBlockRequest
  ): IO[AwsError, zio.aws.s3.model.GetPublicAccessBlockResponse.ReadOnly]
  def putObjectLegalHold(
      request: PutObjectLegalHoldRequest
  ): IO[AwsError, zio.aws.s3.model.PutObjectLegalHoldResponse.ReadOnly]
  def getObjectLockConfiguration(
      request: GetObjectLockConfigurationRequest
  ): IO[AwsError, zio.aws.s3.model.GetObjectLockConfigurationResponse.ReadOnly]
  def getBucketLocation(
      request: GetBucketLocationRequest
  ): IO[AwsError, zio.aws.s3.model.GetBucketLocationResponse.ReadOnly]
  def deleteObjects(
      request: DeleteObjectsRequest
  ): IO[AwsError, zio.aws.s3.model.DeleteObjectsResponse.ReadOnly]
  def abortMultipartUpload(
      request: AbortMultipartUploadRequest
  ): IO[AwsError, zio.aws.s3.model.AbortMultipartUploadResponse.ReadOnly]
  def getBucketPolicyStatus(
      request: GetBucketPolicyStatusRequest
  ): IO[AwsError, zio.aws.s3.model.GetBucketPolicyStatusResponse.ReadOnly]
  def deleteBucketOwnershipControls(
      request: DeleteBucketOwnershipControlsRequest
  ): IO[AwsError, Unit]
  def putObjectRetention(
      request: PutObjectRetentionRequest
  ): IO[AwsError, zio.aws.s3.model.PutObjectRetentionResponse.ReadOnly]
  def putBucketCors(request: PutBucketCorsRequest): IO[AwsError, Unit]
  def deleteObjectTagging(
      request: DeleteObjectTaggingRequest
  ): IO[AwsError, zio.aws.s3.model.DeleteObjectTaggingResponse.ReadOnly]
  def deletePublicAccessBlock(
      request: DeletePublicAccessBlockRequest
  ): IO[AwsError, Unit]
  def deleteBucketEncryption(
      request: DeleteBucketEncryptionRequest
  ): IO[AwsError, Unit]
  def completeMultipartUpload(
      request: CompleteMultipartUploadRequest
  ): IO[AwsError, zio.aws.s3.model.CompleteMultipartUploadResponse.ReadOnly]
  def getObjectTagging(
      request: GetObjectTaggingRequest
  ): IO[AwsError, zio.aws.s3.model.GetObjectTaggingResponse.ReadOnly]
  def putObjectLockConfiguration(
      request: PutObjectLockConfigurationRequest
  ): IO[AwsError, ReadOnly]
  def putBucketAccelerateConfiguration(
      request: PutBucketAccelerateConfigurationRequest
  ): IO[AwsError, Unit]
  def getBucketNotificationConfiguration(
      request: GetBucketNotificationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.s3.model.GetBucketNotificationConfigurationResponse.ReadOnly
  ]
}
object S3 {
  val live: ZLayer[AwsConfig, java.lang.Throwable, S3] = customized(identity)
  def customized(
      customization: S3AsyncClientBuilder => S3AsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, S3] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: S3AsyncClientBuilder => S3AsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, S3] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = S3AsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[S3AsyncClient, S3AsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[S3AsyncClient, S3AsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new S3Impl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class S3Impl[R](
      override val api: S3AsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends S3
      with AwsServiceBase[R] {
    override val serviceName: String = "S3"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): S3Impl[R1] = new S3Impl(api, newAspect, r)
    def uploadPart(
        request: UploadPartRequest,
        body: ZStream[Any, AwsError, Byte]
    ): IO[AwsError, zio.aws.s3.model.UploadPartResponse.ReadOnly] =
      asyncRequestInputStream[
        software.amazon.awssdk.services.s3.model.UploadPartRequest,
        UploadPartResponse
      ](
        "uploadPart",
        api.uploadPart,
        (r: software.amazon.awssdk.services.s3.model.UploadPartRequest) =>
          java.util.Optional.ofNullable(r.contentLength())
      )(request.buildAwsValue(), body)
        .map(zio.aws.s3.model.UploadPartResponse.wrap)
        .provideEnvironment(r)
    def createMultipartUpload(
        request: CreateMultipartUploadRequest
    ): IO[AwsError, zio.aws.s3.model.CreateMultipartUploadResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest,
        CreateMultipartUploadResponse
      ]("createMultipartUpload", api.createMultipartUpload)(
        request.buildAwsValue()
      ).map(zio.aws.s3.model.CreateMultipartUploadResponse.wrap)
        .provideEnvironment(r)
    def putBucketPolicy(request: PutBucketPolicyRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest,
        PutBucketPolicyResponse
      ]("putBucketPolicy", api.putBucketPolicy)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getBucketPolicy(
        request: GetBucketPolicyRequest
    ): IO[AwsError, zio.aws.s3.model.GetBucketPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.GetBucketPolicyRequest,
        GetBucketPolicyResponse
      ]("getBucketPolicy", api.getBucketPolicy)(request.buildAwsValue())
        .map(zio.aws.s3.model.GetBucketPolicyResponse.wrap)
        .provideEnvironment(r)
    def putBucketIntelligentTieringConfiguration(
        request: PutBucketIntelligentTieringConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.PutBucketIntelligentTieringConfigurationRequest,
      PutBucketIntelligentTieringConfigurationResponse
    ](
      "putBucketIntelligentTieringConfiguration",
      api.putBucketIntelligentTieringConfiguration
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def restoreObject(
        request: RestoreObjectRequest
    ): IO[AwsError, zio.aws.s3.model.RestoreObjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.RestoreObjectRequest,
        RestoreObjectResponse
      ]("restoreObject", api.restoreObject)(request.buildAwsValue())
        .map(zio.aws.s3.model.RestoreObjectResponse.wrap)
        .provideEnvironment(r)
    def deleteBucketWebsite(
        request: DeleteBucketWebsiteRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteRequest,
      DeleteBucketWebsiteResponse
    ]("deleteBucketWebsite", api.deleteBucketWebsite)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putBucketLifecycleConfiguration(
        request: PutBucketLifecycleConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest,
      PutBucketLifecycleConfigurationResponse
    ]("putBucketLifecycleConfiguration", api.putBucketLifecycleConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listObjectVersions(
        request: ListObjectVersionsRequest
    ): ZStream[Any, AwsError, zio.aws.s3.model.ObjectVersion.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest,
        ObjectVersion,
        ListObjectVersionsPublisher
      ]("listObjectVersions", api.listObjectVersionsPaginator, _.versions())(
        request.buildAwsValue()
      ).map(item => zio.aws.s3.model.ObjectVersion.wrap(item))
        .provideEnvironment(r)
    def listObjectVersionsPaginated(
        request: ListObjectVersionsRequest
    ): IO[AwsError, zio.aws.s3.model.ListObjectVersionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest,
        ListObjectVersionsResponse
      ]("listObjectVersions", api.listObjectVersions)(request.buildAwsValue())
        .map(zio.aws.s3.model.ListObjectVersionsResponse.wrap)
        .provideEnvironment(r)
    def putBucketLogging(request: PutBucketLoggingRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.PutBucketLoggingRequest,
        PutBucketLoggingResponse
      ]("putBucketLogging", api.putBucketLogging)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteBucketPolicy(
        request: DeleteBucketPolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.DeleteBucketPolicyRequest,
      DeleteBucketPolicyResponse
    ]("deleteBucketPolicy", api.deleteBucketPolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putBucketAnalyticsConfiguration(
        request: PutBucketAnalyticsConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationRequest,
      PutBucketAnalyticsConfigurationResponse
    ]("putBucketAnalyticsConfiguration", api.putBucketAnalyticsConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteBucketInventoryConfiguration(
        request: DeleteBucketInventoryConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationRequest,
      DeleteBucketInventoryConfigurationResponse
    ](
      "deleteBucketInventoryConfiguration",
      api.deleteBucketInventoryConfiguration
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getBucketAnalyticsConfiguration(
        request: GetBucketAnalyticsConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.s3.model.GetBucketAnalyticsConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationRequest,
      GetBucketAnalyticsConfigurationResponse
    ]("getBucketAnalyticsConfiguration", api.getBucketAnalyticsConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.s3.model.GetBucketAnalyticsConfigurationResponse.wrap)
      .provideEnvironment(r)
    def putObjectAcl(
        request: PutObjectAclRequest
    ): IO[AwsError, zio.aws.s3.model.PutObjectAclResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.PutObjectAclRequest,
        PutObjectAclResponse
      ]("putObjectAcl", api.putObjectAcl)(request.buildAwsValue())
        .map(zio.aws.s3.model.PutObjectAclResponse.wrap)
        .provideEnvironment(r)
    def listBucketAnalyticsConfigurations(
        request: ListBucketAnalyticsConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.s3.model.ListBucketAnalyticsConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsRequest,
      ListBucketAnalyticsConfigurationsResponse
    ](
      "listBucketAnalyticsConfigurations",
      api.listBucketAnalyticsConfigurations
    )(request.buildAwsValue())
      .map(zio.aws.s3.model.ListBucketAnalyticsConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def deleteBucketLifecycle(
        request: DeleteBucketLifecycleRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.DeleteBucketLifecycleRequest,
      DeleteBucketLifecycleResponse
    ]("deleteBucketLifecycle", api.deleteBucketLifecycle)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getObjectAcl(
        request: GetObjectAclRequest
    ): IO[AwsError, zio.aws.s3.model.GetObjectAclResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.GetObjectAclRequest,
        GetObjectAclResponse
      ]("getObjectAcl", api.getObjectAcl)(request.buildAwsValue())
        .map(zio.aws.s3.model.GetObjectAclResponse.wrap)
        .provideEnvironment(r)
    def listBucketInventoryConfigurations(
        request: ListBucketInventoryConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.s3.model.ListBucketInventoryConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsRequest,
      ListBucketInventoryConfigurationsResponse
    ](
      "listBucketInventoryConfigurations",
      api.listBucketInventoryConfigurations
    )(request.buildAwsValue())
      .map(zio.aws.s3.model.ListBucketInventoryConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def listMultipartUploads(
        request: ListMultipartUploadsRequest
    ): ZStream[Any, AwsError, zio.aws.s3.model.MultipartUpload.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest,
        MultipartUpload,
        ListMultipartUploadsPublisher
      ]("listMultipartUploads", api.listMultipartUploadsPaginator, _.uploads())(
        request.buildAwsValue()
      ).map(item => zio.aws.s3.model.MultipartUpload.wrap(item))
        .provideEnvironment(r)
    def listMultipartUploadsPaginated(
        request: ListMultipartUploadsRequest
    ): IO[AwsError, zio.aws.s3.model.ListMultipartUploadsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest,
        ListMultipartUploadsResponse
      ]("listMultipartUploads", api.listMultipartUploads)(
        request.buildAwsValue()
      ).map(zio.aws.s3.model.ListMultipartUploadsResponse.wrap)
        .provideEnvironment(r)
    def getBucketLifecycleConfiguration(
        request: GetBucketLifecycleConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.s3.model.GetBucketLifecycleConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationRequest,
      GetBucketLifecycleConfigurationResponse
    ]("getBucketLifecycleConfiguration", api.getBucketLifecycleConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.s3.model.GetBucketLifecycleConfigurationResponse.wrap)
      .provideEnvironment(r)
    def getBucketEncryption(
        request: GetBucketEncryptionRequest
    ): IO[AwsError, zio.aws.s3.model.GetBucketEncryptionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.GetBucketEncryptionRequest,
        GetBucketEncryptionResponse
      ]("getBucketEncryption", api.getBucketEncryption)(request.buildAwsValue())
        .map(zio.aws.s3.model.GetBucketEncryptionResponse.wrap)
        .provideEnvironment(r)
    def writeGetObjectResponse(
        request: WriteGetObjectResponseRequest,
        body: ZStream[Any, AwsError, Byte]
    ): IO[AwsError, Unit] = asyncRequestInputStream[
      software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest,
      WriteGetObjectResponseResponse
    ](
      "writeGetObjectResponse",
      api.writeGetObjectResponse,
      (r: software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest) =>
        java.util.Optional.ofNullable(r.contentLength())
    )(request.buildAwsValue(), body).unit.provideEnvironment(r)
    def getBucketCors(
        request: GetBucketCorsRequest
    ): IO[AwsError, zio.aws.s3.model.GetBucketCorsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.GetBucketCorsRequest,
        GetBucketCorsResponse
      ]("getBucketCors", api.getBucketCors)(request.buildAwsValue())
        .map(zio.aws.s3.model.GetBucketCorsResponse.wrap)
        .provideEnvironment(r)
    def getObjectRetention(
        request: GetObjectRetentionRequest
    ): IO[AwsError, zio.aws.s3.model.GetObjectRetentionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.GetObjectRetentionRequest,
        GetObjectRetentionResponse
      ]("getObjectRetention", api.getObjectRetention)(request.buildAwsValue())
        .map(zio.aws.s3.model.GetObjectRetentionResponse.wrap)
        .provideEnvironment(r)
    def getBucketLogging(
        request: GetBucketLoggingRequest
    ): IO[AwsError, zio.aws.s3.model.GetBucketLoggingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.GetBucketLoggingRequest,
        GetBucketLoggingResponse
      ]("getBucketLogging", api.getBucketLogging)(request.buildAwsValue())
        .map(zio.aws.s3.model.GetBucketLoggingResponse.wrap)
        .provideEnvironment(r)
    def listParts(
        request: ListPartsRequest
    ): ZStream[Any, AwsError, zio.aws.s3.model.Part.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.s3.model.ListPartsRequest,
        Part,
        ListPartsPublisher
      ]("listParts", api.listPartsPaginator, _.parts())(request.buildAwsValue())
        .map(item => zio.aws.s3.model.Part.wrap(item))
        .provideEnvironment(r)
    def listPartsPaginated(
        request: ListPartsRequest
    ): IO[AwsError, zio.aws.s3.model.ListPartsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.ListPartsRequest,
        ListPartsResponse
      ]("listParts", api.listParts)(request.buildAwsValue())
        .map(zio.aws.s3.model.ListPartsResponse.wrap)
        .provideEnvironment(r)
    def getObjectAttributes(
        request: GetObjectAttributesRequest
    ): IO[AwsError, zio.aws.s3.model.GetObjectAttributesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.GetObjectAttributesRequest,
        GetObjectAttributesResponse
      ]("getObjectAttributes", api.getObjectAttributes)(request.buildAwsValue())
        .map(zio.aws.s3.model.GetObjectAttributesResponse.wrap)
        .provideEnvironment(r)
    def listBucketIntelligentTieringConfigurations(
        request: ListBucketIntelligentTieringConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.s3.model.ListBucketIntelligentTieringConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsRequest,
      ListBucketIntelligentTieringConfigurationsResponse
    ](
      "listBucketIntelligentTieringConfigurations",
      api.listBucketIntelligentTieringConfigurations
    )(request.buildAwsValue())
      .map(
        zio.aws.s3.model.ListBucketIntelligentTieringConfigurationsResponse.wrap
      )
      .provideEnvironment(r)
    def listBucketMetricsConfigurations(
        request: ListBucketMetricsConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.s3.model.ListBucketMetricsConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsRequest,
      ListBucketMetricsConfigurationsResponse
    ]("listBucketMetricsConfigurations", api.listBucketMetricsConfigurations)(
      request.buildAwsValue()
    ).map(zio.aws.s3.model.ListBucketMetricsConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def putBucketMetricsConfiguration(
        request: PutBucketMetricsConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationRequest,
      PutBucketMetricsConfigurationResponse
    ]("putBucketMetricsConfiguration", api.putBucketMetricsConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteBucketAnalyticsConfiguration(
        request: DeleteBucketAnalyticsConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationRequest,
      DeleteBucketAnalyticsConfigurationResponse
    ](
      "deleteBucketAnalyticsConfiguration",
      api.deleteBucketAnalyticsConfiguration
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteBucketReplication(
        request: DeleteBucketReplicationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.DeleteBucketReplicationRequest,
      DeleteBucketReplicationResponse
    ]("deleteBucketReplication", api.deleteBucketReplication)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def uploadPartCopy(
        request: UploadPartCopyRequest
    ): IO[AwsError, zio.aws.s3.model.UploadPartCopyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.UploadPartCopyRequest,
        UploadPartCopyResponse
      ]("uploadPartCopy", api.uploadPartCopy)(request.buildAwsValue())
        .map(zio.aws.s3.model.UploadPartCopyResponse.wrap)
        .provideEnvironment(r)
    def getObjectLegalHold(
        request: GetObjectLegalHoldRequest
    ): IO[AwsError, zio.aws.s3.model.GetObjectLegalHoldResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.GetObjectLegalHoldRequest,
        GetObjectLegalHoldResponse
      ]("getObjectLegalHold", api.getObjectLegalHold)(request.buildAwsValue())
        .map(zio.aws.s3.model.GetObjectLegalHoldResponse.wrap)
        .provideEnvironment(r)
    def getBucketRequestPayment(
        request: GetBucketRequestPaymentRequest
    ): IO[AwsError, zio.aws.s3.model.GetBucketRequestPaymentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentRequest,
        GetBucketRequestPaymentResponse
      ]("getBucketRequestPayment", api.getBucketRequestPayment)(
        request.buildAwsValue()
      ).map(zio.aws.s3.model.GetBucketRequestPaymentResponse.wrap)
        .provideEnvironment(r)
    def getBucketMetricsConfiguration(
        request: GetBucketMetricsConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.s3.model.GetBucketMetricsConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationRequest,
      GetBucketMetricsConfigurationResponse
    ]("getBucketMetricsConfiguration", api.getBucketMetricsConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.s3.model.GetBucketMetricsConfigurationResponse.wrap)
      .provideEnvironment(r)
    def copyObject(
        request: CopyObjectRequest
    ): IO[AwsError, zio.aws.s3.model.CopyObjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.CopyObjectRequest,
        CopyObjectResponse
      ]("copyObject", api.copyObject)(request.buildAwsValue())
        .map(zio.aws.s3.model.CopyObjectResponse.wrap)
        .provideEnvironment(r)
    def putBucketWebsite(request: PutBucketWebsiteRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.PutBucketWebsiteRequest,
        PutBucketWebsiteResponse
      ]("putBucketWebsite", api.putBucketWebsite)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getBucketAccelerateConfiguration(
        request: GetBucketAccelerateConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.s3.model.GetBucketAccelerateConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationRequest,
      GetBucketAccelerateConfigurationResponse
    ]("getBucketAccelerateConfiguration", api.getBucketAccelerateConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.s3.model.GetBucketAccelerateConfigurationResponse.wrap)
      .provideEnvironment(r)
    def headBucket(request: HeadBucketRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.HeadBucketRequest,
        HeadBucketResponse
      ]("headBucket", api.headBucket)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteObject(
        request: DeleteObjectRequest
    ): IO[AwsError, zio.aws.s3.model.DeleteObjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.DeleteObjectRequest,
        DeleteObjectResponse
      ]("deleteObject", api.deleteObject)(request.buildAwsValue())
        .map(zio.aws.s3.model.DeleteObjectResponse.wrap)
        .provideEnvironment(r)
    def getBucketOwnershipControls(
        request: GetBucketOwnershipControlsRequest
    ): IO[
      AwsError,
      zio.aws.s3.model.GetBucketOwnershipControlsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.GetBucketOwnershipControlsRequest,
      GetBucketOwnershipControlsResponse
    ]("getBucketOwnershipControls", api.getBucketOwnershipControls)(
      request.buildAwsValue()
    ).map(zio.aws.s3.model.GetBucketOwnershipControlsResponse.wrap)
      .provideEnvironment(r)
    def putBucketReplication(
        request: PutBucketReplicationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest,
      PutBucketReplicationResponse
    ]("putBucketReplication", api.putBucketReplication)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteBucket(request: DeleteBucketRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.DeleteBucketRequest,
        DeleteBucketResponse
      ]("deleteBucket", api.deleteBucket)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def putBucketNotificationConfiguration(
        request: PutBucketNotificationConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest,
      PutBucketNotificationConfigurationResponse
    ](
      "putBucketNotificationConfiguration",
      api.putBucketNotificationConfiguration
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteBucketMetricsConfiguration(
        request: DeleteBucketMetricsConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest,
      DeleteBucketMetricsConfigurationResponse
    ]("deleteBucketMetricsConfiguration", api.deleteBucketMetricsConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createBucket(
        request: CreateBucketRequest
    ): IO[AwsError, zio.aws.s3.model.CreateBucketResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.CreateBucketRequest,
        CreateBucketResponse
      ]("createBucket", api.createBucket)(request.buildAwsValue())
        .map(zio.aws.s3.model.CreateBucketResponse.wrap)
        .provideEnvironment(r)
    def listObjects(
        request: ListObjectsRequest
    ): IO[AwsError, zio.aws.s3.model.ListObjectsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.ListObjectsRequest,
        ListObjectsResponse
      ]("listObjects", api.listObjects)(request.buildAwsValue())
        .map(zio.aws.s3.model.ListObjectsResponse.wrap)
        .provideEnvironment(r)
    def listBuckets()
        : IO[AwsError, zio.aws.s3.model.ListBucketsResponse.ReadOnly] =
      asyncRequestResponse[ListBucketsRequest, ListBucketsResponse](
        "listBuckets",
        api.listBuckets
      )(ListBucketsRequest.builder().build())
        .map(zio.aws.s3.model.ListBucketsResponse.wrap)
        .provideEnvironment(r)
    def getBucketTagging(
        request: GetBucketTaggingRequest
    ): IO[AwsError, zio.aws.s3.model.GetBucketTaggingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.GetBucketTaggingRequest,
        GetBucketTaggingResponse
      ]("getBucketTagging", api.getBucketTagging)(request.buildAwsValue())
        .map(zio.aws.s3.model.GetBucketTaggingResponse.wrap)
        .provideEnvironment(r)
    def putObject(
        request: PutObjectRequest,
        body: ZStream[Any, AwsError, Byte]
    ): IO[AwsError, zio.aws.s3.model.PutObjectResponse.ReadOnly] =
      asyncRequestInputStream[
        software.amazon.awssdk.services.s3.model.PutObjectRequest,
        PutObjectResponse
      ](
        "putObject",
        api.putObject,
        (r: software.amazon.awssdk.services.s3.model.PutObjectRequest) =>
          java.util.Optional.ofNullable(r.contentLength())
      )(request.buildAwsValue(), body)
        .map(zio.aws.s3.model.PutObjectResponse.wrap)
        .provideEnvironment(r)
    def putBucketTagging(request: PutBucketTaggingRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.PutBucketTaggingRequest,
        PutBucketTaggingResponse
      ]("putBucketTagging", api.putBucketTagging)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteBucketTagging(
        request: DeleteBucketTaggingRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.DeleteBucketTaggingRequest,
      DeleteBucketTaggingResponse
    ]("deleteBucketTagging", api.deleteBucketTagging)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putBucketEncryption(
        request: PutBucketEncryptionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.PutBucketEncryptionRequest,
      PutBucketEncryptionResponse
    ]("putBucketEncryption", api.putBucketEncryption)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putBucketRequestPayment(
        request: PutBucketRequestPaymentRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentRequest,
      PutBucketRequestPaymentResponse
    ]("putBucketRequestPayment", api.putBucketRequestPayment)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getObject(
        request: GetObjectRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.s3.model.GetObjectResponse.ReadOnly,
      Byte
    ]] = asyncRequestOutputStream[
      software.amazon.awssdk.services.s3.model.GetObjectRequest,
      GetObjectResponse
    ](
      "getObject",
      api.getObject[Task[StreamingOutputResult[R, GetObjectResponse, Byte]]]
    )(request.buildAwsValue())
      .map(
        _.mapResponse(zio.aws.s3.model.GetObjectResponse.wrap)
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def putObjectTagging(
        request: PutObjectTaggingRequest
    ): IO[AwsError, zio.aws.s3.model.PutObjectTaggingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest,
        PutObjectTaggingResponse
      ]("putObjectTagging", api.putObjectTagging)(request.buildAwsValue())
        .map(zio.aws.s3.model.PutObjectTaggingResponse.wrap)
        .provideEnvironment(r)
    def deleteBucketCors(request: DeleteBucketCorsRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.DeleteBucketCorsRequest,
        DeleteBucketCorsResponse
      ]("deleteBucketCors", api.deleteBucketCors)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def putPublicAccessBlock(
        request: PutPublicAccessBlockRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.PutPublicAccessBlockRequest,
      PutPublicAccessBlockResponse
    ]("putPublicAccessBlock", api.putPublicAccessBlock)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getObjectTorrent(
        request: GetObjectTorrentRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.s3.model.GetObjectTorrentResponse.ReadOnly,
      Byte
    ]] = asyncRequestOutputStream[
      software.amazon.awssdk.services.s3.model.GetObjectTorrentRequest,
      GetObjectTorrentResponse
    ](
      "getObjectTorrent",
      api.getObjectTorrent[Task[
        StreamingOutputResult[R, GetObjectTorrentResponse, Byte]
      ]]
    )(request.buildAwsValue())
      .map(
        _.mapResponse(zio.aws.s3.model.GetObjectTorrentResponse.wrap)
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getBucketInventoryConfiguration(
        request: GetBucketInventoryConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.s3.model.GetBucketInventoryConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationRequest,
      GetBucketInventoryConfigurationResponse
    ]("getBucketInventoryConfiguration", api.getBucketInventoryConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.s3.model.GetBucketInventoryConfigurationResponse.wrap)
      .provideEnvironment(r)
    def getBucketVersioning(
        request: GetBucketVersioningRequest
    ): IO[AwsError, zio.aws.s3.model.GetBucketVersioningResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.GetBucketVersioningRequest,
        GetBucketVersioningResponse
      ]("getBucketVersioning", api.getBucketVersioning)(request.buildAwsValue())
        .map(zio.aws.s3.model.GetBucketVersioningResponse.wrap)
        .provideEnvironment(r)
    def putBucketOwnershipControls(
        request: PutBucketOwnershipControlsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.PutBucketOwnershipControlsRequest,
      PutBucketOwnershipControlsResponse
    ]("putBucketOwnershipControls", api.putBucketOwnershipControls)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def headObject(
        request: HeadObjectRequest
    ): IO[AwsError, zio.aws.s3.model.HeadObjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.HeadObjectRequest,
        HeadObjectResponse
      ]("headObject", api.headObject)(request.buildAwsValue())
        .map(zio.aws.s3.model.HeadObjectResponse.wrap)
        .provideEnvironment(r)
    def selectObjectContent(
        request: SelectObjectContentRequest
    ): ZStream[Any, AwsError, zio.aws.s3.model.RecordsEvent.ReadOnly] =
      asyncRequestEventOutputStream[
        software.amazon.awssdk.services.s3.model.SelectObjectContentRequest,
        SelectObjectContentResponse,
        SelectObjectContentResponseHandler,
        SelectObjectContentEventStream,
        RecordsEvent
      ](
        "SelectObjectContent",
        (
            request: software.amazon.awssdk.services.s3.model.SelectObjectContentRequest,
            handler: SelectObjectContentResponseHandler
        ) => api.selectObjectContent(request, handler),
        (impl: EventStreamResponseHandler[
          SelectObjectContentResponse,
          SelectObjectContentEventStream
        ]) =>
          new SelectObjectContentResponseHandler {
            override def responseReceived(
                response: SelectObjectContentResponse
            ): Unit = impl.responseReceived(response)
            override def onEventStream(
                publisher: SdkPublisher[SelectObjectContentEventStream]
            ): Unit = impl.onEventStream(publisher)
            override def exceptionOccurred(
                throwable: java.lang.Throwable
            ): Unit = impl.exceptionOccurred(throwable)
            override def complete(): Unit = impl.complete()
          }
      )(request.buildAwsValue())
        .map(item => zio.aws.s3.model.RecordsEvent.wrap(item))
        .provideEnvironment(r)
    def getBucketWebsite(
        request: GetBucketWebsiteRequest
    ): IO[AwsError, zio.aws.s3.model.GetBucketWebsiteResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.GetBucketWebsiteRequest,
        GetBucketWebsiteResponse
      ]("getBucketWebsite", api.getBucketWebsite)(request.buildAwsValue())
        .map(zio.aws.s3.model.GetBucketWebsiteResponse.wrap)
        .provideEnvironment(r)
    def deleteBucketIntelligentTieringConfiguration(
        request: DeleteBucketIntelligentTieringConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.DeleteBucketIntelligentTieringConfigurationRequest,
      DeleteBucketIntelligentTieringConfigurationResponse
    ](
      "deleteBucketIntelligentTieringConfiguration",
      api.deleteBucketIntelligentTieringConfiguration
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def putBucketInventoryConfiguration(
        request: PutBucketInventoryConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest,
      PutBucketInventoryConfigurationResponse
    ]("putBucketInventoryConfiguration", api.putBucketInventoryConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getBucketIntelligentTieringConfiguration(
        request: GetBucketIntelligentTieringConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.s3.model.GetBucketIntelligentTieringConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationRequest,
      GetBucketIntelligentTieringConfigurationResponse
    ](
      "getBucketIntelligentTieringConfiguration",
      api.getBucketIntelligentTieringConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.s3.model.GetBucketIntelligentTieringConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def getBucketAcl(
        request: GetBucketAclRequest
    ): IO[AwsError, zio.aws.s3.model.GetBucketAclResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.GetBucketAclRequest,
        GetBucketAclResponse
      ]("getBucketAcl", api.getBucketAcl)(request.buildAwsValue())
        .map(zio.aws.s3.model.GetBucketAclResponse.wrap)
        .provideEnvironment(r)
    def listObjectsV2(
        request: ListObjectsV2Request
    ): ZStream[Any, AwsError, zio.aws.s3.model.S3Object.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.s3.model.ListObjectsV2Request,
        S3Object,
        ListObjectsV2Publisher
      ]("listObjectsV2", api.listObjectsV2Paginator, _.contents())(
        request.buildAwsValue()
      ).map(item => zio.aws.s3.model.S3Object.wrap(item)).provideEnvironment(r)
    def listObjectsV2Paginated(
        request: ListObjectsV2Request
    ): IO[AwsError, zio.aws.s3.model.ListObjectsV2Response.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.ListObjectsV2Request,
        ListObjectsV2Response
      ]("listObjectsV2", api.listObjectsV2)(request.buildAwsValue())
        .map(zio.aws.s3.model.ListObjectsV2Response.wrap)
        .provideEnvironment(r)
    def putBucketVersioning(
        request: PutBucketVersioningRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest,
      PutBucketVersioningResponse
    ]("putBucketVersioning", api.putBucketVersioning)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putBucketAcl(request: PutBucketAclRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.PutBucketAclRequest,
        PutBucketAclResponse
      ]("putBucketAcl", api.putBucketAcl)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getBucketReplication(
        request: GetBucketReplicationRequest
    ): IO[AwsError, zio.aws.s3.model.GetBucketReplicationResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.GetBucketReplicationRequest,
        GetBucketReplicationResponse
      ]("getBucketReplication", api.getBucketReplication)(
        request.buildAwsValue()
      ).map(zio.aws.s3.model.GetBucketReplicationResponse.wrap)
        .provideEnvironment(r)
    def getPublicAccessBlock(
        request: GetPublicAccessBlockRequest
    ): IO[AwsError, zio.aws.s3.model.GetPublicAccessBlockResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.GetPublicAccessBlockRequest,
        GetPublicAccessBlockResponse
      ]("getPublicAccessBlock", api.getPublicAccessBlock)(
        request.buildAwsValue()
      ).map(zio.aws.s3.model.GetPublicAccessBlockResponse.wrap)
        .provideEnvironment(r)
    def putObjectLegalHold(
        request: PutObjectLegalHoldRequest
    ): IO[AwsError, zio.aws.s3.model.PutObjectLegalHoldResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.PutObjectLegalHoldRequest,
        PutObjectLegalHoldResponse
      ]("putObjectLegalHold", api.putObjectLegalHold)(request.buildAwsValue())
        .map(zio.aws.s3.model.PutObjectLegalHoldResponse.wrap)
        .provideEnvironment(r)
    def getObjectLockConfiguration(
        request: GetObjectLockConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.s3.model.GetObjectLockConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationRequest,
      GetObjectLockConfigurationResponse
    ]("getObjectLockConfiguration", api.getObjectLockConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.s3.model.GetObjectLockConfigurationResponse.wrap)
      .provideEnvironment(r)
    def getBucketLocation(
        request: GetBucketLocationRequest
    ): IO[AwsError, zio.aws.s3.model.GetBucketLocationResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.GetBucketLocationRequest,
        GetBucketLocationResponse
      ]("getBucketLocation", api.getBucketLocation)(request.buildAwsValue())
        .map(zio.aws.s3.model.GetBucketLocationResponse.wrap)
        .provideEnvironment(r)
    def deleteObjects(
        request: DeleteObjectsRequest
    ): IO[AwsError, zio.aws.s3.model.DeleteObjectsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.DeleteObjectsRequest,
        DeleteObjectsResponse
      ]("deleteObjects", api.deleteObjects)(request.buildAwsValue())
        .map(zio.aws.s3.model.DeleteObjectsResponse.wrap)
        .provideEnvironment(r)
    def abortMultipartUpload(
        request: AbortMultipartUploadRequest
    ): IO[AwsError, zio.aws.s3.model.AbortMultipartUploadResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest,
        AbortMultipartUploadResponse
      ]("abortMultipartUpload", api.abortMultipartUpload)(
        request.buildAwsValue()
      ).map(zio.aws.s3.model.AbortMultipartUploadResponse.wrap)
        .provideEnvironment(r)
    def getBucketPolicyStatus(
        request: GetBucketPolicyStatusRequest
    ): IO[AwsError, zio.aws.s3.model.GetBucketPolicyStatusResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusRequest,
        GetBucketPolicyStatusResponse
      ]("getBucketPolicyStatus", api.getBucketPolicyStatus)(
        request.buildAwsValue()
      ).map(zio.aws.s3.model.GetBucketPolicyStatusResponse.wrap)
        .provideEnvironment(r)
    def deleteBucketOwnershipControls(
        request: DeleteBucketOwnershipControlsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.DeleteBucketOwnershipControlsRequest,
      DeleteBucketOwnershipControlsResponse
    ]("deleteBucketOwnershipControls", api.deleteBucketOwnershipControls)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putObjectRetention(
        request: PutObjectRetentionRequest
    ): IO[AwsError, zio.aws.s3.model.PutObjectRetentionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest,
        PutObjectRetentionResponse
      ]("putObjectRetention", api.putObjectRetention)(request.buildAwsValue())
        .map(zio.aws.s3.model.PutObjectRetentionResponse.wrap)
        .provideEnvironment(r)
    def putBucketCors(request: PutBucketCorsRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.PutBucketCorsRequest,
        PutBucketCorsResponse
      ]("putBucketCors", api.putBucketCors)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteObjectTagging(
        request: DeleteObjectTaggingRequest
    ): IO[AwsError, zio.aws.s3.model.DeleteObjectTaggingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.DeleteObjectTaggingRequest,
        DeleteObjectTaggingResponse
      ]("deleteObjectTagging", api.deleteObjectTagging)(request.buildAwsValue())
        .map(zio.aws.s3.model.DeleteObjectTaggingResponse.wrap)
        .provideEnvironment(r)
    def deletePublicAccessBlock(
        request: DeletePublicAccessBlockRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.DeletePublicAccessBlockRequest,
      DeletePublicAccessBlockResponse
    ]("deletePublicAccessBlock", api.deletePublicAccessBlock)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteBucketEncryption(
        request: DeleteBucketEncryptionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.DeleteBucketEncryptionRequest,
      DeleteBucketEncryptionResponse
    ]("deleteBucketEncryption", api.deleteBucketEncryption)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def completeMultipartUpload(
        request: CompleteMultipartUploadRequest
    ): IO[AwsError, zio.aws.s3.model.CompleteMultipartUploadResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest,
        CompleteMultipartUploadResponse
      ]("completeMultipartUpload", api.completeMultipartUpload)(
        request.buildAwsValue()
      ).map(zio.aws.s3.model.CompleteMultipartUploadResponse.wrap)
        .provideEnvironment(r)
    def getObjectTagging(
        request: GetObjectTaggingRequest
    ): IO[AwsError, zio.aws.s3.model.GetObjectTaggingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest,
        GetObjectTaggingResponse
      ]("getObjectTagging", api.getObjectTagging)(request.buildAwsValue())
        .map(zio.aws.s3.model.GetObjectTaggingResponse.wrap)
        .provideEnvironment(r)
    def putObjectLockConfiguration(
        request: PutObjectLockConfigurationRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationRequest,
      PutObjectLockConfigurationResponse
    ]("putObjectLockConfiguration", api.putObjectLockConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.s3.model.PutObjectLockConfigurationResponse.wrap)
      .provideEnvironment(r)
    def putBucketAccelerateConfiguration(
        request: PutBucketAccelerateConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest,
      PutBucketAccelerateConfigurationResponse
    ]("putBucketAccelerateConfiguration", api.putBucketAccelerateConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getBucketNotificationConfiguration(
        request: GetBucketNotificationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.s3.model.GetBucketNotificationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationRequest,
      GetBucketNotificationConfigurationResponse
    ](
      "getBucketNotificationConfiguration",
      api.getBucketNotificationConfiguration
    )(request.buildAwsValue())
      .map(zio.aws.s3.model.GetBucketNotificationConfigurationResponse.wrap)
      .provideEnvironment(r)
  }
  def uploadPart(
      request: UploadPartRequest,
      body: ZStream[Any, AwsError, Byte]
  ): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.UploadPartResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.uploadPart(request, body))
  def createMultipartUpload(request: CreateMultipartUploadRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.CreateMultipartUploadResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMultipartUpload(request))
  def putBucketPolicy(
      request: PutBucketPolicyRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketPolicy(request))
  def getBucketPolicy(request: GetBucketPolicyRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketPolicy(request))
  def putBucketIntelligentTieringConfiguration(
      request: PutBucketIntelligentTieringConfigurationRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketIntelligentTieringConfiguration(request))
  def restoreObject(request: RestoreObjectRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.RestoreObjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreObject(request))
  def deleteBucketWebsite(
      request: DeleteBucketWebsiteRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBucketWebsite(request))
  def putBucketLifecycleConfiguration(
      request: PutBucketLifecycleConfigurationRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketLifecycleConfiguration(request))
  def listObjectVersions(
      request: ListObjectVersionsRequest
  ): ZStream[zio.aws.s3.S3, AwsError, zio.aws.s3.model.ObjectVersion.ReadOnly] =
    ZStream.serviceWithStream(_.listObjectVersions(request))
  def listObjectVersionsPaginated(request: ListObjectVersionsRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.ListObjectVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listObjectVersionsPaginated(request))
  def putBucketLogging(
      request: PutBucketLoggingRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketLogging(request))
  def deleteBucketPolicy(
      request: DeleteBucketPolicyRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBucketPolicy(request))
  def putBucketAnalyticsConfiguration(
      request: PutBucketAnalyticsConfigurationRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketAnalyticsConfiguration(request))
  def deleteBucketInventoryConfiguration(
      request: DeleteBucketInventoryConfigurationRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBucketInventoryConfiguration(request))
  def getBucketAnalyticsConfiguration(
      request: GetBucketAnalyticsConfigurationRequest
  ): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketAnalyticsConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketAnalyticsConfiguration(request))
  def putObjectAcl(request: PutObjectAclRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.PutObjectAclResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putObjectAcl(request))
  def listBucketAnalyticsConfigurations(
      request: ListBucketAnalyticsConfigurationsRequest
  ): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.ListBucketAnalyticsConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBucketAnalyticsConfigurations(request))
  def deleteBucketLifecycle(
      request: DeleteBucketLifecycleRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBucketLifecycle(request))
  def getObjectAcl(request: GetObjectAclRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetObjectAclResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getObjectAcl(request))
  def listBucketInventoryConfigurations(
      request: ListBucketInventoryConfigurationsRequest
  ): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.ListBucketInventoryConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBucketInventoryConfigurations(request))
  def listMultipartUploads(request: ListMultipartUploadsRequest): ZStream[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.MultipartUpload.ReadOnly
  ] = ZStream.serviceWithStream(_.listMultipartUploads(request))
  def listMultipartUploadsPaginated(request: ListMultipartUploadsRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.ListMultipartUploadsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMultipartUploadsPaginated(request))
  def getBucketLifecycleConfiguration(
      request: GetBucketLifecycleConfigurationRequest
  ): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketLifecycleConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketLifecycleConfiguration(request))
  def getBucketEncryption(request: GetBucketEncryptionRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketEncryptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketEncryption(request))
  def writeGetObjectResponse(
      request: WriteGetObjectResponseRequest,
      body: ZStream[Any, AwsError, Byte]
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.writeGetObjectResponse(request, body))
  def getBucketCors(request: GetBucketCorsRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketCorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketCors(request))
  def getObjectRetention(request: GetObjectRetentionRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetObjectRetentionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getObjectRetention(request))
  def getBucketLogging(request: GetBucketLoggingRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketLoggingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketLogging(request))
  def listParts(
      request: ListPartsRequest
  ): ZStream[zio.aws.s3.S3, AwsError, zio.aws.s3.model.Part.ReadOnly] =
    ZStream.serviceWithStream(_.listParts(request))
  def listPartsPaginated(
      request: ListPartsRequest
  ): ZIO[zio.aws.s3.S3, AwsError, zio.aws.s3.model.ListPartsResponse.ReadOnly] =
    ZIO.serviceWithZIO(_.listPartsPaginated(request))
  def getObjectAttributes(request: GetObjectAttributesRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetObjectAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getObjectAttributes(request))
  def listBucketIntelligentTieringConfigurations(
      request: ListBucketIntelligentTieringConfigurationsRequest
  ): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.ListBucketIntelligentTieringConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBucketIntelligentTieringConfigurations(request))
  def listBucketMetricsConfigurations(
      request: ListBucketMetricsConfigurationsRequest
  ): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.ListBucketMetricsConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBucketMetricsConfigurations(request))
  def putBucketMetricsConfiguration(
      request: PutBucketMetricsConfigurationRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketMetricsConfiguration(request))
  def deleteBucketAnalyticsConfiguration(
      request: DeleteBucketAnalyticsConfigurationRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBucketAnalyticsConfiguration(request))
  def deleteBucketReplication(
      request: DeleteBucketReplicationRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBucketReplication(request))
  def uploadPartCopy(request: UploadPartCopyRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.UploadPartCopyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.uploadPartCopy(request))
  def getObjectLegalHold(request: GetObjectLegalHoldRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetObjectLegalHoldResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getObjectLegalHold(request))
  def getBucketRequestPayment(request: GetBucketRequestPaymentRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketRequestPaymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketRequestPayment(request))
  def getBucketMetricsConfiguration(
      request: GetBucketMetricsConfigurationRequest
  ): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketMetricsConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketMetricsConfiguration(request))
  def copyObject(request: CopyObjectRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.CopyObjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyObject(request))
  def putBucketWebsite(
      request: PutBucketWebsiteRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketWebsite(request))
  def getBucketAccelerateConfiguration(
      request: GetBucketAccelerateConfigurationRequest
  ): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketAccelerateConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketAccelerateConfiguration(request))
  def headBucket(
      request: HeadBucketRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.headBucket(request))
  def deleteObject(request: DeleteObjectRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.DeleteObjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteObject(request))
  def getBucketOwnershipControls(
      request: GetBucketOwnershipControlsRequest
  ): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketOwnershipControlsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketOwnershipControls(request))
  def putBucketReplication(
      request: PutBucketReplicationRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketReplication(request))
  def deleteBucket(
      request: DeleteBucketRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBucket(request))
  def putBucketNotificationConfiguration(
      request: PutBucketNotificationConfigurationRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketNotificationConfiguration(request))
  def deleteBucketMetricsConfiguration(
      request: DeleteBucketMetricsConfigurationRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBucketMetricsConfiguration(request))
  def createBucket(request: CreateBucketRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.CreateBucketResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBucket(request))
  def listObjects(request: ListObjectsRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.ListObjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listObjects(request))
  def listBuckets(): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.ListBucketsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBuckets())
  def getBucketTagging(request: GetBucketTaggingRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketTaggingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketTagging(request))
  def putObject(
      request: PutObjectRequest,
      body: ZStream[Any, AwsError, Byte]
  ): ZIO[zio.aws.s3.S3, AwsError, zio.aws.s3.model.PutObjectResponse.ReadOnly] =
    ZIO.serviceWithZIO(_.putObject(request, body))
  def putBucketTagging(
      request: PutBucketTaggingRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketTagging(request))
  def deleteBucketTagging(
      request: DeleteBucketTaggingRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBucketTagging(request))
  def putBucketEncryption(
      request: PutBucketEncryptionRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketEncryption(request))
  def putBucketRequestPayment(
      request: PutBucketRequestPaymentRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketRequestPayment(request))
  def getObject(
      request: GetObjectRequest
  ): ZIO[zio.aws.s3.S3, AwsError, StreamingOutputResult[
    Any,
    zio.aws.s3.model.GetObjectResponse.ReadOnly,
    Byte
  ]] = ZIO.serviceWithZIO(_.getObject(request))
  def putObjectTagging(request: PutObjectTaggingRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.PutObjectTaggingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putObjectTagging(request))
  def deleteBucketCors(
      request: DeleteBucketCorsRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBucketCors(request))
  def putPublicAccessBlock(
      request: PutPublicAccessBlockRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putPublicAccessBlock(request))
  def getObjectTorrent(
      request: GetObjectTorrentRequest
  ): ZIO[zio.aws.s3.S3, AwsError, StreamingOutputResult[
    Any,
    zio.aws.s3.model.GetObjectTorrentResponse.ReadOnly,
    Byte
  ]] = ZIO.serviceWithZIO(_.getObjectTorrent(request))
  def getBucketInventoryConfiguration(
      request: GetBucketInventoryConfigurationRequest
  ): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketInventoryConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketInventoryConfiguration(request))
  def getBucketVersioning(request: GetBucketVersioningRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketVersioningResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketVersioning(request))
  def putBucketOwnershipControls(
      request: PutBucketOwnershipControlsRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketOwnershipControls(request))
  def headObject(request: HeadObjectRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.HeadObjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.headObject(request))
  def selectObjectContent(
      request: SelectObjectContentRequest
  ): ZStream[zio.aws.s3.S3, AwsError, zio.aws.s3.model.RecordsEvent.ReadOnly] =
    ZStream.serviceWithStream(_.selectObjectContent(request))
  def getBucketWebsite(request: GetBucketWebsiteRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketWebsiteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketWebsite(request))
  def deleteBucketIntelligentTieringConfiguration(
      request: DeleteBucketIntelligentTieringConfigurationRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBucketIntelligentTieringConfiguration(request))
  def putBucketInventoryConfiguration(
      request: PutBucketInventoryConfigurationRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketInventoryConfiguration(request))
  def getBucketIntelligentTieringConfiguration(
      request: GetBucketIntelligentTieringConfigurationRequest
  ): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketIntelligentTieringConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketIntelligentTieringConfiguration(request))
  def getBucketAcl(request: GetBucketAclRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketAclResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketAcl(request))
  def listObjectsV2(
      request: ListObjectsV2Request
  ): ZStream[zio.aws.s3.S3, AwsError, zio.aws.s3.model.S3Object.ReadOnly] =
    ZStream.serviceWithStream(_.listObjectsV2(request))
  def listObjectsV2Paginated(request: ListObjectsV2Request): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.ListObjectsV2Response.ReadOnly
  ] = ZIO.serviceWithZIO(_.listObjectsV2Paginated(request))
  def putBucketVersioning(
      request: PutBucketVersioningRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketVersioning(request))
  def putBucketAcl(
      request: PutBucketAclRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketAcl(request))
  def getBucketReplication(request: GetBucketReplicationRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketReplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketReplication(request))
  def getPublicAccessBlock(request: GetPublicAccessBlockRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetPublicAccessBlockResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPublicAccessBlock(request))
  def putObjectLegalHold(request: PutObjectLegalHoldRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.PutObjectLegalHoldResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putObjectLegalHold(request))
  def getObjectLockConfiguration(
      request: GetObjectLockConfigurationRequest
  ): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetObjectLockConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getObjectLockConfiguration(request))
  def getBucketLocation(request: GetBucketLocationRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketLocationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketLocation(request))
  def deleteObjects(request: DeleteObjectsRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.DeleteObjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteObjects(request))
  def abortMultipartUpload(request: AbortMultipartUploadRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.AbortMultipartUploadResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.abortMultipartUpload(request))
  def getBucketPolicyStatus(request: GetBucketPolicyStatusRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketPolicyStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketPolicyStatus(request))
  def deleteBucketOwnershipControls(
      request: DeleteBucketOwnershipControlsRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBucketOwnershipControls(request))
  def putObjectRetention(request: PutObjectRetentionRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.PutObjectRetentionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putObjectRetention(request))
  def putBucketCors(
      request: PutBucketCorsRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketCors(request))
  def deleteObjectTagging(request: DeleteObjectTaggingRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.DeleteObjectTaggingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteObjectTagging(request))
  def deletePublicAccessBlock(
      request: DeletePublicAccessBlockRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePublicAccessBlock(request))
  def deleteBucketEncryption(
      request: DeleteBucketEncryptionRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBucketEncryption(request))
  def completeMultipartUpload(request: CompleteMultipartUploadRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.CompleteMultipartUploadResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.completeMultipartUpload(request))
  def getObjectTagging(request: GetObjectTaggingRequest): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetObjectTaggingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getObjectTagging(request))
  def putObjectLockConfiguration(
      request: PutObjectLockConfigurationRequest
  ): ZIO[zio.aws.s3.S3, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.putObjectLockConfiguration(request))
  def putBucketAccelerateConfiguration(
      request: PutBucketAccelerateConfigurationRequest
  ): ZIO[zio.aws.s3.S3, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBucketAccelerateConfiguration(request))
  def getBucketNotificationConfiguration(
      request: GetBucketNotificationConfigurationRequest
  ): ZIO[
    zio.aws.s3.S3,
    AwsError,
    zio.aws.s3.model.GetBucketNotificationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketNotificationConfiguration(request))
}
