package zio.aws.s3.model
import scala.jdk.CollectionConverters._
sealed trait BucketLocationConstraint {
  def unwrap: software.amazon.awssdk.services.s3.model.BucketLocationConstraint
}
object BucketLocationConstraint {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.BucketLocationConstraint
  ): zio.aws.s3.model.BucketLocationConstraint = value match {
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.AF_SOUTH_1 =>
      val r = `af-south-1`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.AP_EAST_1 =>
      val r = `ap-east-1`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.AP_NORTHEAST_1 =>
      val r = `ap-northeast-1`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.AP_NORTHEAST_2 =>
      val r = `ap-northeast-2`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.AP_NORTHEAST_3 =>
      val r = `ap-northeast-3`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.AP_SOUTH_1 =>
      val r = `ap-south-1`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.AP_SOUTHEAST_1 =>
      val r = `ap-southeast-1`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.AP_SOUTHEAST_2 =>
      val r = `ap-southeast-2`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.AP_SOUTHEAST_3 =>
      val r = `ap-southeast-3`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.CA_CENTRAL_1 =>
      val r = `ca-central-1`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.CN_NORTH_1 =>
      val r = `cn-north-1`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.CN_NORTHWEST_1 =>
      val r = `cn-northwest-1`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.EU =>
      val r = EU
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.EU_CENTRAL_1 =>
      val r = `eu-central-1`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.EU_NORTH_1 =>
      val r = `eu-north-1`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.EU_SOUTH_1 =>
      val r = `eu-south-1`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.EU_WEST_1 =>
      val r = `eu-west-1`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.EU_WEST_2 =>
      val r = `eu-west-2`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.EU_WEST_3 =>
      val r = `eu-west-3`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.ME_SOUTH_1 =>
      val r = `me-south-1`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.SA_EAST_1 =>
      val r = `sa-east-1`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.US_EAST_2 =>
      val r = `us-east-2`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.US_GOV_EAST_1 =>
      val r = `us-gov-east-1`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.US_GOV_WEST_1 =>
      val r = `us-gov-west-1`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.US_WEST_1 =>
      val r = `us-west-1`
      r
    case software.amazon.awssdk.services.s3.model.BucketLocationConstraint.US_WEST_2 =>
      val r = `us-west-2`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.UNKNOWN_TO_SDK_VERSION
  }
  case object `af-south-1` extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.AF_SOUTH_1
  }
  case object `ap-east-1` extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.AP_EAST_1
  }
  case object `ap-northeast-1`
      extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.AP_NORTHEAST_1
  }
  case object `ap-northeast-2`
      extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.AP_NORTHEAST_2
  }
  case object `ap-northeast-3`
      extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.AP_NORTHEAST_3
  }
  case object `ap-south-1` extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.AP_SOUTH_1
  }
  case object `ap-southeast-1`
      extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.AP_SOUTHEAST_1
  }
  case object `ap-southeast-2`
      extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.AP_SOUTHEAST_2
  }
  case object `ap-southeast-3`
      extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.AP_SOUTHEAST_3
  }
  case object `ca-central-1` extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.CA_CENTRAL_1
  }
  case object `cn-north-1` extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.CN_NORTH_1
  }
  case object `cn-northwest-1`
      extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.CN_NORTHWEST_1
  }
  case object EU extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.EU
  }
  case object `eu-central-1` extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.EU_CENTRAL_1
  }
  case object `eu-north-1` extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.EU_NORTH_1
  }
  case object `eu-south-1` extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.EU_SOUTH_1
  }
  case object `eu-west-1` extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.EU_WEST_1
  }
  case object `eu-west-2` extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.EU_WEST_2
  }
  case object `eu-west-3` extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.EU_WEST_3
  }
  case object `me-south-1` extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.ME_SOUTH_1
  }
  case object `sa-east-1` extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.SA_EAST_1
  }
  case object `us-east-2` extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.US_EAST_2
  }
  case object `us-gov-east-1`
      extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.US_GOV_EAST_1
  }
  case object `us-gov-west-1`
      extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.US_GOV_WEST_1
  }
  case object `us-west-1` extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.US_WEST_1
  }
  case object `us-west-2` extends zio.aws.s3.model.BucketLocationConstraint {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLocationConstraint =
      software.amazon.awssdk.services.s3.model.BucketLocationConstraint.US_WEST_2
  }
}
