package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  RecordDelimiter,
  FieldDelimiter,
  AllowQuotedRecordDelimiter,
  QuoteEscapeCharacter,
  QuoteCharacter,
  Comments
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CSVInput(
    fileHeaderInfo: Optional[zio.aws.s3.model.FileHeaderInfo] = Optional.Absent,
    comments: Optional[Comments] = Optional.Absent,
    quoteEscapeCharacter: Optional[QuoteEscapeCharacter] = Optional.Absent,
    recordDelimiter: Optional[RecordDelimiter] = Optional.Absent,
    fieldDelimiter: Optional[FieldDelimiter] = Optional.Absent,
    quoteCharacter: Optional[QuoteCharacter] = Optional.Absent,
    allowQuotedRecordDelimiter: Optional[AllowQuotedRecordDelimiter] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.CSVInput = {
    import CSVInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CSVInput
      .builder()
      .optionallyWith(fileHeaderInfo.map(value => value.unwrap))(
        _.fileHeaderInfo
      )
      .optionallyWith(
        comments.map(value => Comments.unwrap(value): java.lang.String)
      )(_.comments)
      .optionallyWith(
        quoteEscapeCharacter.map(value =>
          QuoteEscapeCharacter.unwrap(value): java.lang.String
        )
      )(_.quoteEscapeCharacter)
      .optionallyWith(
        recordDelimiter.map(value =>
          RecordDelimiter.unwrap(value): java.lang.String
        )
      )(_.recordDelimiter)
      .optionallyWith(
        fieldDelimiter.map(value =>
          FieldDelimiter.unwrap(value): java.lang.String
        )
      )(_.fieldDelimiter)
      .optionallyWith(
        quoteCharacter.map(value =>
          QuoteCharacter.unwrap(value): java.lang.String
        )
      )(_.quoteCharacter)
      .optionallyWith(
        allowQuotedRecordDelimiter.map(value =>
          AllowQuotedRecordDelimiter.unwrap(value): java.lang.Boolean
        )
      )(_.allowQuotedRecordDelimiter)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CSVInput.ReadOnly =
    zio.aws.s3.model.CSVInput.wrap(buildAwsValue())
}
object CSVInput {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.CSVInput] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CSVInput = zio.aws.s3.model.CSVInput(
      fileHeaderInfo.map(value => value),
      comments.map(value => value),
      quoteEscapeCharacter.map(value => value),
      recordDelimiter.map(value => value),
      fieldDelimiter.map(value => value),
      quoteCharacter.map(value => value),
      allowQuotedRecordDelimiter.map(value => value)
    )
    def fileHeaderInfo: Optional[zio.aws.s3.model.FileHeaderInfo]
    def comments: Optional[Comments]
    def quoteEscapeCharacter: Optional[QuoteEscapeCharacter]
    def recordDelimiter: Optional[RecordDelimiter]
    def fieldDelimiter: Optional[FieldDelimiter]
    def quoteCharacter: Optional[QuoteCharacter]
    def allowQuotedRecordDelimiter: Optional[AllowQuotedRecordDelimiter]
    def getFileHeaderInfo: ZIO[Any, AwsError, zio.aws.s3.model.FileHeaderInfo] =
      AwsError.unwrapOptionField("fileHeaderInfo", fileHeaderInfo)
    def getComments: ZIO[Any, AwsError, Comments] =
      AwsError.unwrapOptionField("comments", comments)
    def getQuoteEscapeCharacter: ZIO[Any, AwsError, QuoteEscapeCharacter] =
      AwsError.unwrapOptionField("quoteEscapeCharacter", quoteEscapeCharacter)
    def getRecordDelimiter: ZIO[Any, AwsError, RecordDelimiter] =
      AwsError.unwrapOptionField("recordDelimiter", recordDelimiter)
    def getFieldDelimiter: ZIO[Any, AwsError, FieldDelimiter] =
      AwsError.unwrapOptionField("fieldDelimiter", fieldDelimiter)
    def getQuoteCharacter: ZIO[Any, AwsError, QuoteCharacter] =
      AwsError.unwrapOptionField("quoteCharacter", quoteCharacter)
    def getAllowQuotedRecordDelimiter
        : ZIO[Any, AwsError, AllowQuotedRecordDelimiter] =
      AwsError.unwrapOptionField(
        "allowQuotedRecordDelimiter",
        allowQuotedRecordDelimiter
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CSVInput
  ) extends zio.aws.s3.model.CSVInput.ReadOnly {
    override val fileHeaderInfo: Optional[zio.aws.s3.model.FileHeaderInfo] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileHeaderInfo())
        .map(value => zio.aws.s3.model.FileHeaderInfo.wrap(value))
    override val comments: Optional[Comments] = zio.aws.core.internal
      .optionalFromNullable(impl.comments())
      .map(value => zio.aws.s3.model.primitives.Comments(value))
    override val quoteEscapeCharacter: Optional[QuoteEscapeCharacter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quoteEscapeCharacter())
        .map(value => zio.aws.s3.model.primitives.QuoteEscapeCharacter(value))
    override val recordDelimiter: Optional[RecordDelimiter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordDelimiter())
        .map(value => zio.aws.s3.model.primitives.RecordDelimiter(value))
    override val fieldDelimiter: Optional[FieldDelimiter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fieldDelimiter())
        .map(value => zio.aws.s3.model.primitives.FieldDelimiter(value))
    override val quoteCharacter: Optional[QuoteCharacter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quoteCharacter())
        .map(value => zio.aws.s3.model.primitives.QuoteCharacter(value))
    override val allowQuotedRecordDelimiter
        : Optional[AllowQuotedRecordDelimiter] = zio.aws.core.internal
      .optionalFromNullable(impl.allowQuotedRecordDelimiter())
      .map(value =>
        zio.aws.s3.model.primitives.AllowQuotedRecordDelimiter(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CSVInput
  ): zio.aws.s3.model.CSVInput.ReadOnly = new Wrapper(impl)
}
