package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CompletedMultipartUpload(
    parts: Optional[Iterable[zio.aws.s3.model.CompletedPart]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CompletedMultipartUpload = {
    import CompletedMultipartUpload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CompletedMultipartUpload
      .builder()
      .optionallyWith(
        parts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parts)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CompletedMultipartUpload.ReadOnly =
    zio.aws.s3.model.CompletedMultipartUpload.wrap(buildAwsValue())
}
object CompletedMultipartUpload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CompletedMultipartUpload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CompletedMultipartUpload =
      zio.aws.s3.model.CompletedMultipartUpload(
        parts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def parts: Optional[List[zio.aws.s3.model.CompletedPart.ReadOnly]]
    def getParts
        : ZIO[Any, AwsError, List[zio.aws.s3.model.CompletedPart.ReadOnly]] =
      AwsError.unwrapOptionField("parts", parts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CompletedMultipartUpload
  ) extends zio.aws.s3.model.CompletedMultipartUpload.ReadOnly {
    override val parts
        : Optional[List[zio.aws.s3.model.CompletedPart.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.CompletedPart.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CompletedMultipartUpload
  ): zio.aws.s3.model.CompletedMultipartUpload.ReadOnly = new Wrapper(impl)
}
