package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  KeyPrefixEquals,
  HttpErrorCodeReturnedEquals
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Condition(
    httpErrorCodeReturnedEquals: Optional[HttpErrorCodeReturnedEquals] =
      Optional.Absent,
    keyPrefixEquals: Optional[KeyPrefixEquals] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Condition = {
    import Condition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Condition
      .builder()
      .optionallyWith(
        httpErrorCodeReturnedEquals.map(value =>
          HttpErrorCodeReturnedEquals.unwrap(value): java.lang.String
        )
      )(_.httpErrorCodeReturnedEquals)
      .optionallyWith(
        keyPrefixEquals.map(value =>
          KeyPrefixEquals.unwrap(value): java.lang.String
        )
      )(_.keyPrefixEquals)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.Condition.ReadOnly =
    zio.aws.s3.model.Condition.wrap(buildAwsValue())
}
object Condition {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Condition] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.Condition = zio.aws.s3.model.Condition(
      httpErrorCodeReturnedEquals.map(value => value),
      keyPrefixEquals.map(value => value)
    )
    def httpErrorCodeReturnedEquals: Optional[HttpErrorCodeReturnedEquals]
    def keyPrefixEquals: Optional[KeyPrefixEquals]
    def getHttpErrorCodeReturnedEquals
        : ZIO[Any, AwsError, HttpErrorCodeReturnedEquals] =
      AwsError.unwrapOptionField(
        "httpErrorCodeReturnedEquals",
        httpErrorCodeReturnedEquals
      )
    def getKeyPrefixEquals: ZIO[Any, AwsError, KeyPrefixEquals] =
      AwsError.unwrapOptionField("keyPrefixEquals", keyPrefixEquals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Condition
  ) extends zio.aws.s3.model.Condition.ReadOnly {
    override val httpErrorCodeReturnedEquals
        : Optional[HttpErrorCodeReturnedEquals] = zio.aws.core.internal
      .optionalFromNullable(impl.httpErrorCodeReturnedEquals())
      .map(value =>
        zio.aws.s3.model.primitives.HttpErrorCodeReturnedEquals(value)
      )
    override val keyPrefixEquals: Optional[KeyPrefixEquals] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyPrefixEquals())
        .map(value => zio.aws.s3.model.primitives.KeyPrefixEquals(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Condition
  ): zio.aws.s3.model.Condition.ReadOnly = new Wrapper(impl)
}
