package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  GrantRead,
  GrantReadACP,
  ObjectLockEnabledForBucket,
  GrantWriteACP,
  GrantFullControl,
  BucketName,
  GrantWrite
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateBucketRequest(
    acl: Optional[zio.aws.s3.model.BucketCannedACL] = Optional.Absent,
    bucket: BucketName,
    createBucketConfiguration: Optional[
      zio.aws.s3.model.CreateBucketConfiguration
    ] = Optional.Absent,
    grantFullControl: Optional[GrantFullControl] = Optional.Absent,
    grantRead: Optional[GrantRead] = Optional.Absent,
    grantReadACP: Optional[GrantReadACP] = Optional.Absent,
    grantWrite: Optional[GrantWrite] = Optional.Absent,
    grantWriteACP: Optional[GrantWriteACP] = Optional.Absent,
    objectLockEnabledForBucket: Optional[ObjectLockEnabledForBucket] =
      Optional.Absent,
    objectOwnership: Optional[zio.aws.s3.model.ObjectOwnership] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CreateBucketRequest = {
    import CreateBucketRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CreateBucketRequest
      .builder()
      .optionallyWith(acl.map(value => value.unwrap))(_.acl)
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        createBucketConfiguration.map(value => value.buildAwsValue())
      )(_.createBucketConfiguration)
      .optionallyWith(
        grantFullControl.map(value =>
          GrantFullControl.unwrap(value): java.lang.String
        )
      )(_.grantFullControl)
      .optionallyWith(
        grantRead.map(value => GrantRead.unwrap(value): java.lang.String)
      )(_.grantRead)
      .optionallyWith(
        grantReadACP.map(value => GrantReadACP.unwrap(value): java.lang.String)
      )(_.grantReadACP)
      .optionallyWith(
        grantWrite.map(value => GrantWrite.unwrap(value): java.lang.String)
      )(_.grantWrite)
      .optionallyWith(
        grantWriteACP.map(value =>
          GrantWriteACP.unwrap(value): java.lang.String
        )
      )(_.grantWriteACP)
      .optionallyWith(
        objectLockEnabledForBucket.map(value =>
          ObjectLockEnabledForBucket.unwrap(value): java.lang.Boolean
        )
      )(_.objectLockEnabledForBucket)
      .optionallyWith(objectOwnership.map(value => value.unwrap))(
        _.objectOwnership
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CreateBucketRequest.ReadOnly =
    zio.aws.s3.model.CreateBucketRequest.wrap(buildAwsValue())
}
object CreateBucketRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CreateBucketRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CreateBucketRequest =
      zio.aws.s3.model.CreateBucketRequest(
        acl.map(value => value),
        bucket,
        createBucketConfiguration.map(value => value.asEditable),
        grantFullControl.map(value => value),
        grantRead.map(value => value),
        grantReadACP.map(value => value),
        grantWrite.map(value => value),
        grantWriteACP.map(value => value),
        objectLockEnabledForBucket.map(value => value),
        objectOwnership.map(value => value)
      )
    def acl: Optional[zio.aws.s3.model.BucketCannedACL]
    def bucket: BucketName
    def createBucketConfiguration
        : Optional[zio.aws.s3.model.CreateBucketConfiguration.ReadOnly]
    def grantFullControl: Optional[GrantFullControl]
    def grantRead: Optional[GrantRead]
    def grantReadACP: Optional[GrantReadACP]
    def grantWrite: Optional[GrantWrite]
    def grantWriteACP: Optional[GrantWriteACP]
    def objectLockEnabledForBucket: Optional[ObjectLockEnabledForBucket]
    def objectOwnership: Optional[zio.aws.s3.model.ObjectOwnership]
    def getAcl: ZIO[Any, AwsError, zio.aws.s3.model.BucketCannedACL] =
      AwsError.unwrapOptionField("acl", acl)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getCreateBucketConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.CreateBucketConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "createBucketConfiguration",
      createBucketConfiguration
    )
    def getGrantFullControl: ZIO[Any, AwsError, GrantFullControl] =
      AwsError.unwrapOptionField("grantFullControl", grantFullControl)
    def getGrantRead: ZIO[Any, AwsError, GrantRead] =
      AwsError.unwrapOptionField("grantRead", grantRead)
    def getGrantReadACP: ZIO[Any, AwsError, GrantReadACP] =
      AwsError.unwrapOptionField("grantReadACP", grantReadACP)
    def getGrantWrite: ZIO[Any, AwsError, GrantWrite] =
      AwsError.unwrapOptionField("grantWrite", grantWrite)
    def getGrantWriteACP: ZIO[Any, AwsError, GrantWriteACP] =
      AwsError.unwrapOptionField("grantWriteACP", grantWriteACP)
    def getObjectLockEnabledForBucket
        : ZIO[Any, AwsError, ObjectLockEnabledForBucket] =
      AwsError.unwrapOptionField(
        "objectLockEnabledForBucket",
        objectLockEnabledForBucket
      )
    def getObjectOwnership
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectOwnership] =
      AwsError.unwrapOptionField("objectOwnership", objectOwnership)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CreateBucketRequest
  ) extends zio.aws.s3.model.CreateBucketRequest.ReadOnly {
    override val acl: Optional[zio.aws.s3.model.BucketCannedACL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acl())
        .map(value => zio.aws.s3.model.BucketCannedACL.wrap(value))
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val createBucketConfiguration
        : Optional[zio.aws.s3.model.CreateBucketConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createBucketConfiguration())
        .map(value => zio.aws.s3.model.CreateBucketConfiguration.wrap(value))
    override val grantFullControl: Optional[GrantFullControl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grantFullControl())
        .map(value => zio.aws.s3.model.primitives.GrantFullControl(value))
    override val grantRead: Optional[GrantRead] = zio.aws.core.internal
      .optionalFromNullable(impl.grantRead())
      .map(value => zio.aws.s3.model.primitives.GrantRead(value))
    override val grantReadACP: Optional[GrantReadACP] = zio.aws.core.internal
      .optionalFromNullable(impl.grantReadACP())
      .map(value => zio.aws.s3.model.primitives.GrantReadACP(value))
    override val grantWrite: Optional[GrantWrite] = zio.aws.core.internal
      .optionalFromNullable(impl.grantWrite())
      .map(value => zio.aws.s3.model.primitives.GrantWrite(value))
    override val grantWriteACP: Optional[GrantWriteACP] = zio.aws.core.internal
      .optionalFromNullable(impl.grantWriteACP())
      .map(value => zio.aws.s3.model.primitives.GrantWriteACP(value))
    override val objectLockEnabledForBucket
        : Optional[ObjectLockEnabledForBucket] = zio.aws.core.internal
      .optionalFromNullable(impl.objectLockEnabledForBucket())
      .map(value =>
        zio.aws.s3.model.primitives.ObjectLockEnabledForBucket(value)
      )
    override val objectOwnership: Optional[zio.aws.s3.model.ObjectOwnership] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectOwnership())
        .map(value => zio.aws.s3.model.ObjectOwnership.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CreateBucketRequest
  ): zio.aws.s3.model.CreateBucketRequest.ReadOnly = new Wrapper(impl)
}
