package zio.aws.s3.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  AbortRuleId,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  SSEKMSEncryptionContext,
  ObjectKey,
  BucketName,
  SSEKMSKeyId,
  AbortDate,
  BucketKeyEnabled,
  MultipartUploadId
}
import scala.jdk.CollectionConverters._
final case class CreateMultipartUploadResponse(
    abortDate: Optional[AbortDate] = Optional.Absent,
    abortRuleId: Optional[AbortRuleId] = Optional.Absent,
    bucket: Optional[BucketName] = Optional.Absent,
    key: Optional[ObjectKey] = Optional.Absent,
    uploadId: Optional[MultipartUploadId] = Optional.Absent,
    serverSideEncryption: Optional[zio.aws.s3.model.ServerSideEncryption] =
      Optional.Absent,
    sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] = Optional.Absent,
    sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] = Optional.Absent,
    ssekmsKeyId: Optional[SSEKMSKeyId] = Optional.Absent,
    ssekmsEncryptionContext: Optional[SSEKMSEncryptionContext] =
      Optional.Absent,
    bucketKeyEnabled: Optional[BucketKeyEnabled] = Optional.Absent,
    requestCharged: Optional[zio.aws.s3.model.RequestCharged] = Optional.Absent,
    checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse = {
    import CreateMultipartUploadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse
      .builder()
      .optionallyWith(abortDate.map(value => AbortDate.unwrap(value): Instant))(
        _.abortDate
      )
      .optionallyWith(
        abortRuleId.map(value => AbortRuleId.unwrap(value): java.lang.String)
      )(_.abortRuleId)
      .optionallyWith(
        bucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        key.map(value => ObjectKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        uploadId.map(value => MultipartUploadId.unwrap(value): java.lang.String)
      )(_.uploadId)
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(
        ssekmsKeyId.map(value => SSEKMSKeyId.unwrap(value): java.lang.String)
      )(_.ssekmsKeyId)
      .optionallyWith(
        ssekmsEncryptionContext.map(value =>
          SSEKMSEncryptionContext.unwrap(value): java.lang.String
        )
      )(_.ssekmsEncryptionContext)
      .optionallyWith(
        bucketKeyEnabled.map(value =>
          BucketKeyEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.bucketKeyEnabled)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CreateMultipartUploadResponse.ReadOnly =
    zio.aws.s3.model.CreateMultipartUploadResponse.wrap(buildAwsValue())
}
object CreateMultipartUploadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CreateMultipartUploadResponse =
      zio.aws.s3.model.CreateMultipartUploadResponse(
        abortDate.map(value => value),
        abortRuleId.map(value => value),
        bucket.map(value => value),
        key.map(value => value),
        uploadId.map(value => value),
        serverSideEncryption.map(value => value),
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        ssekmsKeyId.map(value => value),
        ssekmsEncryptionContext.map(value => value),
        bucketKeyEnabled.map(value => value),
        requestCharged.map(value => value),
        checksumAlgorithm.map(value => value)
      )
    def abortDate: Optional[AbortDate]
    def abortRuleId: Optional[AbortRuleId]
    def bucket: Optional[BucketName]
    def key: Optional[ObjectKey]
    def uploadId: Optional[MultipartUploadId]
    def serverSideEncryption: Optional[zio.aws.s3.model.ServerSideEncryption]
    def sseCustomerAlgorithm: Optional[SSECustomerAlgorithm]
    def sseCustomerKeyMD5: Optional[SSECustomerKeyMD5]
    def ssekmsKeyId: Optional[SSEKMSKeyId]
    def ssekmsEncryptionContext: Optional[SSEKMSEncryptionContext]
    def bucketKeyEnabled: Optional[BucketKeyEnabled]
    def requestCharged: Optional[zio.aws.s3.model.RequestCharged]
    def checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm]
    def getAbortDate: ZIO[Any, AwsError, AbortDate] =
      AwsError.unwrapOptionField("abortDate", abortDate)
    def getAbortRuleId: ZIO[Any, AwsError, AbortRuleId] =
      AwsError.unwrapOptionField("abortRuleId", abortRuleId)
    def getBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKey: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", key)
    def getUploadId: ZIO[Any, AwsError, MultipartUploadId] =
      AwsError.unwrapOptionField("uploadId", uploadId)
    def getServerSideEncryption
        : ZIO[Any, AwsError, zio.aws.s3.model.ServerSideEncryption] =
      AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getSsekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyId)
    def getSsekmsEncryptionContext
        : ZIO[Any, AwsError, SSEKMSEncryptionContext] = AwsError
      .unwrapOptionField("ssekmsEncryptionContext", ssekmsEncryptionContext)
    def getBucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabled)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, zio.aws.s3.model.ChecksumAlgorithm] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse
  ) extends zio.aws.s3.model.CreateMultipartUploadResponse.ReadOnly {
    override val abortDate: Optional[AbortDate] = zio.aws.core.internal
      .optionalFromNullable(impl.abortDate())
      .map(value => zio.aws.s3.model.primitives.AbortDate(value))
    override val abortRuleId: Optional[AbortRuleId] = zio.aws.core.internal
      .optionalFromNullable(impl.abortRuleId())
      .map(value => zio.aws.s3.model.primitives.AbortRuleId(value))
    override val bucket: Optional[BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.s3.model.primitives.BucketName(value))
    override val key: Optional[ObjectKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.s3.model.primitives.ObjectKey(value))
    override val uploadId: Optional[MultipartUploadId] = zio.aws.core.internal
      .optionalFromNullable(impl.uploadId())
      .map(value => zio.aws.s3.model.primitives.MultipartUploadId(value))
    override val serverSideEncryption
        : Optional[zio.aws.s3.model.ServerSideEncryption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverSideEncryption())
        .map(value => zio.aws.s3.model.ServerSideEncryption.wrap(value))
    override val sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerAlgorithm())
        .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKeyMD5())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val ssekmsKeyId: Optional[SSEKMSKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.ssekmsKeyId())
      .map(value => zio.aws.s3.model.primitives.SSEKMSKeyId(value))
    override val ssekmsEncryptionContext: Optional[SSEKMSEncryptionContext] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ssekmsEncryptionContext())
        .map(value =>
          zio.aws.s3.model.primitives.SSEKMSEncryptionContext(value)
        )
    override val bucketKeyEnabled: Optional[BucketKeyEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketKeyEnabled())
        .map(value => zio.aws.s3.model.primitives.BucketKeyEnabled(value))
    override val requestCharged: Optional[zio.aws.s3.model.RequestCharged] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestCharged())
        .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
    override val checksumAlgorithm
        : Optional[zio.aws.s3.model.ChecksumAlgorithm] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumAlgorithm())
      .map(value => zio.aws.s3.model.ChecksumAlgorithm.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse
  ): zio.aws.s3.model.CreateMultipartUploadResponse.ReadOnly = new Wrapper(impl)
}
