package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteBucketOwnershipControlsRequest(
    bucket: BucketName,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteBucketOwnershipControlsRequest = {
    import DeleteBucketOwnershipControlsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteBucketOwnershipControlsRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.DeleteBucketOwnershipControlsRequest.ReadOnly =
    zio.aws.s3.model.DeleteBucketOwnershipControlsRequest.wrap(buildAwsValue())
}
object DeleteBucketOwnershipControlsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteBucketOwnershipControlsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.DeleteBucketOwnershipControlsRequest =
      zio.aws.s3.model.DeleteBucketOwnershipControlsRequest(
        bucket,
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def expectedBucketOwner: Optional[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteBucketOwnershipControlsRequest
  ) extends zio.aws.s3.model.DeleteBucketOwnershipControlsRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteBucketOwnershipControlsRequest
  ): zio.aws.s3.model.DeleteBucketOwnershipControlsRequest.ReadOnly =
    new Wrapper(impl)
}
