package zio.aws.s3.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  LastModified,
  IsLatest,
  ObjectVersionId,
  ObjectKey
}
import scala.jdk.CollectionConverters._
final case class DeleteMarkerEntry(
    owner: Optional[zio.aws.s3.model.Owner] = Optional.Absent,
    key: Optional[ObjectKey] = Optional.Absent,
    versionId: Optional[ObjectVersionId] = Optional.Absent,
    isLatest: Optional[IsLatest] = Optional.Absent,
    lastModified: Optional[LastModified] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteMarkerEntry = {
    import DeleteMarkerEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteMarkerEntry
      .builder()
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .optionallyWith(
        key.map(value => ObjectKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        isLatest.map(value => IsLatest.unwrap(value): java.lang.Boolean)
      )(_.isLatest)
      .optionallyWith(
        lastModified.map(value => LastModified.unwrap(value): Instant)
      )(_.lastModified)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.DeleteMarkerEntry.ReadOnly =
    zio.aws.s3.model.DeleteMarkerEntry.wrap(buildAwsValue())
}
object DeleteMarkerEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteMarkerEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.DeleteMarkerEntry =
      zio.aws.s3.model.DeleteMarkerEntry(
        owner.map(value => value.asEditable),
        key.map(value => value),
        versionId.map(value => value),
        isLatest.map(value => value),
        lastModified.map(value => value)
      )
    def owner: Optional[zio.aws.s3.model.Owner.ReadOnly]
    def key: Optional[ObjectKey]
    def versionId: Optional[ObjectVersionId]
    def isLatest: Optional[IsLatest]
    def lastModified: Optional[LastModified]
    def getOwner: ZIO[Any, AwsError, zio.aws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", owner)
    def getKey: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", key)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getIsLatest: ZIO[Any, AwsError, IsLatest] =
      AwsError.unwrapOptionField("isLatest", isLatest)
    def getLastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModified)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteMarkerEntry
  ) extends zio.aws.s3.model.DeleteMarkerEntry.ReadOnly {
    override val owner: Optional[zio.aws.s3.model.Owner.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => zio.aws.s3.model.Owner.wrap(value))
    override val key: Optional[ObjectKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.s3.model.primitives.ObjectKey(value))
    override val versionId: Optional[ObjectVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val isLatest: Optional[IsLatest] = zio.aws.core.internal
      .optionalFromNullable(impl.isLatest())
      .map(value => zio.aws.s3.model.primitives.IsLatest(value))
    override val lastModified: Optional[LastModified] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.s3.model.primitives.LastModified(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteMarkerEntry
  ): zio.aws.s3.model.DeleteMarkerEntry.ReadOnly = new Wrapper(impl)
}
