package zio.aws.s3.model
import scala.jdk.CollectionConverters._
sealed trait DeleteMarkerReplicationStatus {
  def unwrap
      : software.amazon.awssdk.services.s3.model.DeleteMarkerReplicationStatus
}
object DeleteMarkerReplicationStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.DeleteMarkerReplicationStatus
  ): zio.aws.s3.model.DeleteMarkerReplicationStatus = value match {
    case software.amazon.awssdk.services.s3.model.DeleteMarkerReplicationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.DeleteMarkerReplicationStatus.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.s3.model.DeleteMarkerReplicationStatus.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3.model.DeleteMarkerReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.DeleteMarkerReplicationStatus =
      software.amazon.awssdk.services.s3.model.DeleteMarkerReplicationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.s3.model.DeleteMarkerReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.DeleteMarkerReplicationStatus =
      software.amazon.awssdk.services.s3.model.DeleteMarkerReplicationStatus.ENABLED
  }
  case object Disabled extends zio.aws.s3.model.DeleteMarkerReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.DeleteMarkerReplicationStatus =
      software.amazon.awssdk.services.s3.model.DeleteMarkerReplicationStatus.DISABLED
  }
}
