package zio.aws.s3.model
import zio.aws.s3.model.primitives.ObjectVersionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteObjectTaggingResponse(
    versionId: Optional[ObjectVersionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteObjectTaggingResponse = {
    import DeleteObjectTaggingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteObjectTaggingResponse
      .builder()
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.DeleteObjectTaggingResponse.ReadOnly =
    zio.aws.s3.model.DeleteObjectTaggingResponse.wrap(buildAwsValue())
}
object DeleteObjectTaggingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteObjectTaggingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.DeleteObjectTaggingResponse =
      zio.aws.s3.model
        .DeleteObjectTaggingResponse(versionId.map(value => value))
    def versionId: Optional[ObjectVersionId]
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectTaggingResponse
  ) extends zio.aws.s3.model.DeleteObjectTaggingResponse.ReadOnly {
    override val versionId: Optional[ObjectVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectTaggingResponse
  ): zio.aws.s3.model.DeleteObjectTaggingResponse.ReadOnly = new Wrapper(impl)
}
