package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Destination(
    bucket: BucketName,
    account: Optional[AccountId] = Optional.Absent,
    storageClass: Optional[zio.aws.s3.model.StorageClass] = Optional.Absent,
    accessControlTranslation: Optional[
      zio.aws.s3.model.AccessControlTranslation
    ] = Optional.Absent,
    encryptionConfiguration: Optional[
      zio.aws.s3.model.EncryptionConfiguration
    ] = Optional.Absent,
    replicationTime: Optional[zio.aws.s3.model.ReplicationTime] =
      Optional.Absent,
    metrics: Optional[zio.aws.s3.model.Metrics] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Destination = {
    import Destination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Destination
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        account.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.account)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(
        accessControlTranslation.map(value => value.buildAwsValue())
      )(_.accessControlTranslation)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .optionallyWith(replicationTime.map(value => value.buildAwsValue()))(
        _.replicationTime
      )
      .optionallyWith(metrics.map(value => value.buildAwsValue()))(_.metrics)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.Destination.ReadOnly =
    zio.aws.s3.model.Destination.wrap(buildAwsValue())
}
object Destination {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Destination] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.Destination = zio.aws.s3.model.Destination(
      bucket,
      account.map(value => value),
      storageClass.map(value => value),
      accessControlTranslation.map(value => value.asEditable),
      encryptionConfiguration.map(value => value.asEditable),
      replicationTime.map(value => value.asEditable),
      metrics.map(value => value.asEditable)
    )
    def bucket: BucketName
    def account: Optional[AccountId]
    def storageClass: Optional[zio.aws.s3.model.StorageClass]
    def accessControlTranslation
        : Optional[zio.aws.s3.model.AccessControlTranslation.ReadOnly]
    def encryptionConfiguration
        : Optional[zio.aws.s3.model.EncryptionConfiguration.ReadOnly]
    def replicationTime: Optional[zio.aws.s3.model.ReplicationTime.ReadOnly]
    def metrics: Optional[zio.aws.s3.model.Metrics.ReadOnly]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getAccount: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("account", account)
    def getStorageClass: ZIO[Any, AwsError, zio.aws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getAccessControlTranslation: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.AccessControlTranslation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accessControlTranslation",
      accessControlTranslation
    )
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
    def getReplicationTime
        : ZIO[Any, AwsError, zio.aws.s3.model.ReplicationTime.ReadOnly] =
      AwsError.unwrapOptionField("replicationTime", replicationTime)
    def getMetrics: ZIO[Any, AwsError, zio.aws.s3.model.Metrics.ReadOnly] =
      AwsError.unwrapOptionField("metrics", metrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Destination
  ) extends zio.aws.s3.model.Destination.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val account: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.account())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
    override val storageClass: Optional[zio.aws.s3.model.StorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value => zio.aws.s3.model.StorageClass.wrap(value))
    override val accessControlTranslation
        : Optional[zio.aws.s3.model.AccessControlTranslation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessControlTranslation())
        .map(value => zio.aws.s3.model.AccessControlTranslation.wrap(value))
    override val encryptionConfiguration
        : Optional[zio.aws.s3.model.EncryptionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfiguration())
        .map(value => zio.aws.s3.model.EncryptionConfiguration.wrap(value))
    override val replicationTime
        : Optional[zio.aws.s3.model.ReplicationTime.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTime())
        .map(value => zio.aws.s3.model.ReplicationTime.wrap(value))
    override val metrics: Optional[zio.aws.s3.model.Metrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metrics())
        .map(value => zio.aws.s3.model.Metrics.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Destination
  ): zio.aws.s3.model.Destination.ReadOnly = new Wrapper(impl)
}
