package zio.aws.s3.model
import zio.aws.s3.model.primitives.ReplicaKmsKeyID
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EncryptionConfiguration(
    replicaKmsKeyID: Optional[ReplicaKmsKeyID] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.EncryptionConfiguration = {
    import EncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.EncryptionConfiguration
      .builder()
      .optionallyWith(
        replicaKmsKeyID.map(value =>
          ReplicaKmsKeyID.unwrap(value): java.lang.String
        )
      )(_.replicaKmsKeyID)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.EncryptionConfiguration.ReadOnly =
    zio.aws.s3.model.EncryptionConfiguration.wrap(buildAwsValue())
}
object EncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.EncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.EncryptionConfiguration = zio.aws.s3.model
      .EncryptionConfiguration(replicaKmsKeyID.map(value => value))
    def replicaKmsKeyID: Optional[ReplicaKmsKeyID]
    def getReplicaKmsKeyID: ZIO[Any, AwsError, ReplicaKmsKeyID] =
      AwsError.unwrapOptionField("replicaKmsKeyID", replicaKmsKeyID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.EncryptionConfiguration
  ) extends zio.aws.s3.model.EncryptionConfiguration.ReadOnly {
    override val replicaKmsKeyID: Optional[ReplicaKmsKeyID] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicaKmsKeyID())
        .map(value => zio.aws.s3.model.primitives.ReplicaKmsKeyID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.EncryptionConfiguration
  ): zio.aws.s3.model.EncryptionConfiguration.ReadOnly = new Wrapper(impl)
}
