package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBucketLoggingResponse(
    loggingEnabled: Optional[zio.aws.s3.model.LoggingEnabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketLoggingResponse = {
    import GetBucketLoggingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketLoggingResponse
      .builder()
      .optionallyWith(loggingEnabled.map(value => value.buildAwsValue()))(
        _.loggingEnabled
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetBucketLoggingResponse.ReadOnly =
    zio.aws.s3.model.GetBucketLoggingResponse.wrap(buildAwsValue())
}
object GetBucketLoggingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketLoggingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketLoggingResponse = zio.aws.s3.model
      .GetBucketLoggingResponse(loggingEnabled.map(value => value.asEditable))
    def loggingEnabled: Optional[zio.aws.s3.model.LoggingEnabled.ReadOnly]
    def getLoggingEnabled
        : ZIO[Any, AwsError, zio.aws.s3.model.LoggingEnabled.ReadOnly] =
      AwsError.unwrapOptionField("loggingEnabled", loggingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketLoggingResponse
  ) extends zio.aws.s3.model.GetBucketLoggingResponse.ReadOnly {
    override val loggingEnabled
        : Optional[zio.aws.s3.model.LoggingEnabled.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingEnabled())
        .map(value => zio.aws.s3.model.LoggingEnabled.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketLoggingResponse
  ): zio.aws.s3.model.GetBucketLoggingResponse.ReadOnly = new Wrapper(impl)
}
