package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBucketMetricsConfigurationResponse(
    metricsConfiguration: Optional[zio.aws.s3.model.MetricsConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationResponse = {
    import GetBucketMetricsConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationResponse
      .builder()
      .optionallyWith(metricsConfiguration.map(value => value.buildAwsValue()))(
        _.metricsConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.GetBucketMetricsConfigurationResponse.ReadOnly =
    zio.aws.s3.model.GetBucketMetricsConfigurationResponse.wrap(buildAwsValue())
}
object GetBucketMetricsConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketMetricsConfigurationResponse =
      zio.aws.s3.model.GetBucketMetricsConfigurationResponse(
        metricsConfiguration.map(value => value.asEditable)
      )
    def metricsConfiguration
        : Optional[zio.aws.s3.model.MetricsConfiguration.ReadOnly]
    def getMetricsConfiguration
        : ZIO[Any, AwsError, zio.aws.s3.model.MetricsConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("metricsConfiguration", metricsConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationResponse
  ) extends zio.aws.s3.model.GetBucketMetricsConfigurationResponse.ReadOnly {
    override val metricsConfiguration
        : Optional[zio.aws.s3.model.MetricsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricsConfiguration())
        .map(value => zio.aws.s3.model.MetricsConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationResponse
  ): zio.aws.s3.model.GetBucketMetricsConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
