package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBucketPolicyStatusResponse(
    policyStatus: Optional[zio.aws.s3.model.PolicyStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusResponse = {
    import GetBucketPolicyStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusResponse
      .builder()
      .optionallyWith(policyStatus.map(value => value.buildAwsValue()))(
        _.policyStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetBucketPolicyStatusResponse.ReadOnly =
    zio.aws.s3.model.GetBucketPolicyStatusResponse.wrap(buildAwsValue())
}
object GetBucketPolicyStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketPolicyStatusResponse =
      zio.aws.s3.model.GetBucketPolicyStatusResponse(
        policyStatus.map(value => value.asEditable)
      )
    def policyStatus: Optional[zio.aws.s3.model.PolicyStatus.ReadOnly]
    def getPolicyStatus
        : ZIO[Any, AwsError, zio.aws.s3.model.PolicyStatus.ReadOnly] =
      AwsError.unwrapOptionField("policyStatus", policyStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusResponse
  ) extends zio.aws.s3.model.GetBucketPolicyStatusResponse.ReadOnly {
    override val policyStatus
        : Optional[zio.aws.s3.model.PolicyStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyStatus())
        .map(value => zio.aws.s3.model.PolicyStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusResponse
  ): zio.aws.s3.model.GetBucketPolicyStatusResponse.ReadOnly = new Wrapper(impl)
}
