package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetBucketTaggingResponse(
    tagSet: Iterable[zio.aws.s3.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketTaggingResponse = {
    import GetBucketTaggingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketTaggingResponse
      .builder()
      .tagSet(tagSet.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetBucketTaggingResponse.ReadOnly =
    zio.aws.s3.model.GetBucketTaggingResponse.wrap(buildAwsValue())
}
object GetBucketTaggingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketTaggingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketTaggingResponse =
      zio.aws.s3.model.GetBucketTaggingResponse(tagSet.map { item =>
        item.asEditable
      })
    def tagSet: List[zio.aws.s3.model.Tag.ReadOnly]
    def getTagSet: ZIO[Any, Nothing, List[zio.aws.s3.model.Tag.ReadOnly]] =
      ZIO.succeed(tagSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketTaggingResponse
  ) extends zio.aws.s3.model.GetBucketTaggingResponse.ReadOnly {
    override val tagSet: List[zio.aws.s3.model.Tag.ReadOnly] = impl
      .tagSet()
      .asScala
      .map { item =>
        zio.aws.s3.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketTaggingResponse
  ): zio.aws.s3.model.GetBucketTaggingResponse.ReadOnly = new Wrapper(impl)
}
