package zio.aws.s3.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  MaxParts,
  PartsCount,
  NextPartNumberMarker,
  PartNumberMarker,
  IsTruncated
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetObjectAttributesParts(
    totalPartsCount: Optional[PartsCount] = Optional.Absent,
    partNumberMarker: Optional[PartNumberMarker] = Optional.Absent,
    nextPartNumberMarker: Optional[NextPartNumberMarker] = Optional.Absent,
    maxParts: Optional[MaxParts] = Optional.Absent,
    isTruncated: Optional[IsTruncated] = Optional.Absent,
    parts: Optional[Iterable[zio.aws.s3.model.ObjectPart]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectAttributesParts = {
    import GetObjectAttributesParts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectAttributesParts
      .builder()
      .optionallyWith(
        totalPartsCount.map(value => PartsCount.unwrap(value): Integer)
      )(_.totalPartsCount)
      .optionallyWith(
        partNumberMarker.map(value => PartNumberMarker.unwrap(value): Integer)
      )(_.partNumberMarker)
      .optionallyWith(
        nextPartNumberMarker.map(value =>
          NextPartNumberMarker.unwrap(value): Integer
        )
      )(_.nextPartNumberMarker)
      .optionallyWith(maxParts.map(value => MaxParts.unwrap(value): Integer))(
        _.maxParts
      )
      .optionallyWith(
        isTruncated.map(value => IsTruncated.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        parts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parts)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetObjectAttributesParts.ReadOnly =
    zio.aws.s3.model.GetObjectAttributesParts.wrap(buildAwsValue())
}
object GetObjectAttributesParts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectAttributesParts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetObjectAttributesParts =
      zio.aws.s3.model.GetObjectAttributesParts(
        totalPartsCount.map(value => value),
        partNumberMarker.map(value => value),
        nextPartNumberMarker.map(value => value),
        maxParts.map(value => value),
        isTruncated.map(value => value),
        parts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def totalPartsCount: Optional[PartsCount]
    def partNumberMarker: Optional[PartNumberMarker]
    def nextPartNumberMarker: Optional[NextPartNumberMarker]
    def maxParts: Optional[MaxParts]
    def isTruncated: Optional[IsTruncated]
    def parts: Optional[List[zio.aws.s3.model.ObjectPart.ReadOnly]]
    def getTotalPartsCount: ZIO[Any, AwsError, PartsCount] =
      AwsError.unwrapOptionField("totalPartsCount", totalPartsCount)
    def getPartNumberMarker: ZIO[Any, AwsError, PartNumberMarker] =
      AwsError.unwrapOptionField("partNumberMarker", partNumberMarker)
    def getNextPartNumberMarker: ZIO[Any, AwsError, NextPartNumberMarker] =
      AwsError.unwrapOptionField("nextPartNumberMarker", nextPartNumberMarker)
    def getMaxParts: ZIO[Any, AwsError, MaxParts] =
      AwsError.unwrapOptionField("maxParts", maxParts)
    def getIsTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getParts
        : ZIO[Any, AwsError, List[zio.aws.s3.model.ObjectPart.ReadOnly]] =
      AwsError.unwrapOptionField("parts", parts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectAttributesParts
  ) extends zio.aws.s3.model.GetObjectAttributesParts.ReadOnly {
    override val totalPartsCount: Optional[PartsCount] = zio.aws.core.internal
      .optionalFromNullable(impl.totalPartsCount())
      .map(value => zio.aws.s3.model.primitives.PartsCount(value))
    override val partNumberMarker: Optional[PartNumberMarker] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partNumberMarker())
        .map(value => zio.aws.s3.model.primitives.PartNumberMarker(value))
    override val nextPartNumberMarker: Optional[NextPartNumberMarker] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextPartNumberMarker())
        .map(value => zio.aws.s3.model.primitives.NextPartNumberMarker(value))
    override val maxParts: Optional[MaxParts] = zio.aws.core.internal
      .optionalFromNullable(impl.maxParts())
      .map(value => zio.aws.s3.model.primitives.MaxParts(value))
    override val isTruncated: Optional[IsTruncated] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.s3.model.primitives.IsTruncated(value))
    override val parts: Optional[List[zio.aws.s3.model.ObjectPart.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.ObjectPart.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectAttributesParts
  ): zio.aws.s3.model.GetObjectAttributesParts.ReadOnly = new Wrapper(impl)
}
