package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetObjectLegalHoldResponse(
    legalHold: Optional[zio.aws.s3.model.ObjectLockLegalHold] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse = {
    import GetObjectLegalHoldResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse
      .builder()
      .optionallyWith(legalHold.map(value => value.buildAwsValue()))(
        _.legalHold
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetObjectLegalHoldResponse.ReadOnly =
    zio.aws.s3.model.GetObjectLegalHoldResponse.wrap(buildAwsValue())
}
object GetObjectLegalHoldResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetObjectLegalHoldResponse =
      zio.aws.s3.model
        .GetObjectLegalHoldResponse(legalHold.map(value => value.asEditable))
    def legalHold: Optional[zio.aws.s3.model.ObjectLockLegalHold.ReadOnly]
    def getLegalHold
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockLegalHold.ReadOnly] =
      AwsError.unwrapOptionField("legalHold", legalHold)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse
  ) extends zio.aws.s3.model.GetObjectLegalHoldResponse.ReadOnly {
    override val legalHold
        : Optional[zio.aws.s3.model.ObjectLockLegalHold.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.legalHold())
        .map(value => zio.aws.s3.model.ObjectLockLegalHold.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse
  ): zio.aws.s3.model.GetObjectLegalHoldResponse.ReadOnly = new Wrapper(impl)
}
