package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GlacierJobParameters(tier: zio.aws.s3.model.Tier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GlacierJobParameters = {
    import GlacierJobParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GlacierJobParameters
      .builder()
      .tier(tier.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GlacierJobParameters.ReadOnly =
    zio.aws.s3.model.GlacierJobParameters.wrap(buildAwsValue())
}
object GlacierJobParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GlacierJobParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GlacierJobParameters =
      zio.aws.s3.model.GlacierJobParameters(tier)
    def tier: zio.aws.s3.model.Tier
    def getTier: ZIO[Any, Nothing, zio.aws.s3.model.Tier] = ZIO.succeed(tier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GlacierJobParameters
  ) extends zio.aws.s3.model.GlacierJobParameters.ReadOnly {
    override val tier: zio.aws.s3.model.Tier =
      zio.aws.s3.model.Tier.wrap(impl.tier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GlacierJobParameters
  ): zio.aws.s3.model.GlacierJobParameters.ReadOnly = new Wrapper(impl)
}
