package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Grant(
    grantee: Optional[zio.aws.s3.model.Grantee] = Optional.Absent,
    permission: Optional[zio.aws.s3.model.Permission] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Grant = {
    import Grant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Grant
      .builder()
      .optionallyWith(grantee.map(value => value.buildAwsValue()))(_.grantee)
      .optionallyWith(permission.map(value => value.unwrap))(_.permission)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.Grant.ReadOnly =
    zio.aws.s3.model.Grant.wrap(buildAwsValue())
}
object Grant {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Grant] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.Grant = zio.aws.s3.model.Grant(
      grantee.map(value => value.asEditable),
      permission.map(value => value)
    )
    def grantee: Optional[zio.aws.s3.model.Grantee.ReadOnly]
    def permission: Optional[zio.aws.s3.model.Permission]
    def getGrantee: ZIO[Any, AwsError, zio.aws.s3.model.Grantee.ReadOnly] =
      AwsError.unwrapOptionField("grantee", grantee)
    def getPermission: ZIO[Any, AwsError, zio.aws.s3.model.Permission] =
      AwsError.unwrapOptionField("permission", permission)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Grant
  ) extends zio.aws.s3.model.Grant.ReadOnly {
    override val grantee: Optional[zio.aws.s3.model.Grantee.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grantee())
        .map(value => zio.aws.s3.model.Grantee.wrap(value))
    override val permission: Optional[zio.aws.s3.model.Permission] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permission())
        .map(value => zio.aws.s3.model.Permission.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Grant
  ): zio.aws.s3.model.Grant.ReadOnly = new Wrapper(impl)
}
