package zio.aws.s3.model
import zio.aws.s3.model.primitives.{URI, ID, EmailAddress, DisplayName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Grantee(
    displayName: Optional[DisplayName] = Optional.Absent,
    emailAddress: Optional[EmailAddress] = Optional.Absent,
    id: Optional[ID] = Optional.Absent,
    `type`: zio.aws.s3.model.Type,
    uri: Optional[URI] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Grantee = {
    import Grantee.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Grantee
      .builder()
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        emailAddress.map(value => EmailAddress.unwrap(value): java.lang.String)
      )(_.emailAddress)
      .optionallyWith(id.map(value => ID.unwrap(value): java.lang.String))(_.id)
      .`type`(`type`.unwrap)
      .optionallyWith(uri.map(value => URI.unwrap(value): java.lang.String))(
        _.uri
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.Grantee.ReadOnly =
    zio.aws.s3.model.Grantee.wrap(buildAwsValue())
}
object Grantee {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Grantee] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.Grantee = zio.aws.s3.model.Grantee(
      displayName.map(value => value),
      emailAddress.map(value => value),
      id.map(value => value),
      `type`,
      uri.map(value => value)
    )
    def displayName: Optional[DisplayName]
    def emailAddress: Optional[EmailAddress]
    def id: Optional[ID]
    def `type`: zio.aws.s3.model.Type
    def uri: Optional[URI]
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getId: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", id)
    def getType: ZIO[Any, Nothing, zio.aws.s3.model.Type] = ZIO.succeed(`type`)
    def getUri: ZIO[Any, AwsError, URI] = AwsError.unwrapOptionField("uri", uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Grantee
  ) extends zio.aws.s3.model.Grantee.ReadOnly {
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.s3.model.primitives.DisplayName(value))
    override val emailAddress: Optional[EmailAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.emailAddress())
      .map(value => zio.aws.s3.model.primitives.EmailAddress(value))
    override val id: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.s3.model.primitives.ID(value))
    override val `type`: zio.aws.s3.model.Type =
      zio.aws.s3.model.Type.wrap(impl.`type`())
    override val uri: Optional[URI] = zio.aws.core.internal
      .optionalFromNullable(impl.uri())
      .map(value => zio.aws.s3.model.primitives.URI(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Grantee
  ): zio.aws.s3.model.Grantee.ReadOnly = new Wrapper(impl)
}
