package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InputSerialization(
    csv: Optional[zio.aws.s3.model.CSVInput] = Optional.Absent,
    compressionType: Optional[zio.aws.s3.model.CompressionType] =
      Optional.Absent,
    json: Optional[zio.aws.s3.model.JSONInput] = Optional.Absent,
    parquet: Optional[zio.aws.s3.model.ParquetInput] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.InputSerialization = {
    import InputSerialization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.InputSerialization
      .builder()
      .optionallyWith(csv.map(value => value.buildAwsValue()))(_.csv)
      .optionallyWith(compressionType.map(value => value.unwrap))(
        _.compressionType
      )
      .optionallyWith(json.map(value => value.buildAwsValue()))(_.json)
      .optionallyWith(parquet.map(value => value.buildAwsValue()))(_.parquet)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.InputSerialization.ReadOnly =
    zio.aws.s3.model.InputSerialization.wrap(buildAwsValue())
}
object InputSerialization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.InputSerialization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.InputSerialization =
      zio.aws.s3.model.InputSerialization(
        csv.map(value => value.asEditable),
        compressionType.map(value => value),
        json.map(value => value.asEditable),
        parquet.map(value => value.asEditable)
      )
    def csv: Optional[zio.aws.s3.model.CSVInput.ReadOnly]
    def compressionType: Optional[zio.aws.s3.model.CompressionType]
    def json: Optional[zio.aws.s3.model.JSONInput.ReadOnly]
    def parquet: Optional[zio.aws.s3.model.ParquetInput.ReadOnly]
    def getCsv: ZIO[Any, AwsError, zio.aws.s3.model.CSVInput.ReadOnly] =
      AwsError.unwrapOptionField("csv", csv)
    def getCompressionType
        : ZIO[Any, AwsError, zio.aws.s3.model.CompressionType] =
      AwsError.unwrapOptionField("compressionType", compressionType)
    def getJson: ZIO[Any, AwsError, zio.aws.s3.model.JSONInput.ReadOnly] =
      AwsError.unwrapOptionField("json", json)
    def getParquet: ZIO[Any, AwsError, zio.aws.s3.model.ParquetInput.ReadOnly] =
      AwsError.unwrapOptionField("parquet", parquet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.InputSerialization
  ) extends zio.aws.s3.model.InputSerialization.ReadOnly {
    override val csv: Optional[zio.aws.s3.model.CSVInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.csv())
        .map(value => zio.aws.s3.model.CSVInput.wrap(value))
    override val compressionType: Optional[zio.aws.s3.model.CompressionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compressionType())
        .map(value => zio.aws.s3.model.CompressionType.wrap(value))
    override val json: Optional[zio.aws.s3.model.JSONInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.json())
        .map(value => zio.aws.s3.model.JSONInput.wrap(value))
    override val parquet: Optional[zio.aws.s3.model.ParquetInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parquet())
        .map(value => zio.aws.s3.model.ParquetInput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.InputSerialization
  ): zio.aws.s3.model.InputSerialization.ReadOnly = new Wrapper(impl)
}
