package zio.aws.s3.model
import zio.aws.s3.model.primitives.Prefix
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IntelligentTieringAndOperator(
    prefix: Optional[Prefix] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.s3.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.IntelligentTieringAndOperator = {
    import IntelligentTieringAndOperator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.IntelligentTieringAndOperator
      .builder()
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.IntelligentTieringAndOperator.ReadOnly =
    zio.aws.s3.model.IntelligentTieringAndOperator.wrap(buildAwsValue())
}
object IntelligentTieringAndOperator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.IntelligentTieringAndOperator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.IntelligentTieringAndOperator =
      zio.aws.s3.model.IntelligentTieringAndOperator(
        prefix.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def prefix: Optional[Prefix]
    def tags: Optional[List[zio.aws.s3.model.Tag.ReadOnly]]
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getTags: ZIO[Any, AwsError, List[zio.aws.s3.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.IntelligentTieringAndOperator
  ) extends zio.aws.s3.model.IntelligentTieringAndOperator.ReadOnly {
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val tags: Optional[List[zio.aws.s3.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.IntelligentTieringAndOperator
  ): zio.aws.s3.model.IntelligentTieringAndOperator.ReadOnly = new Wrapper(impl)
}
