package zio.aws.s3.model
import zio.aws.s3.model.primitives.Prefix
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IntelligentTieringFilter(
    prefix: Optional[Prefix] = Optional.Absent,
    tag: Optional[zio.aws.s3.model.Tag] = Optional.Absent,
    and: Optional[zio.aws.s3.model.IntelligentTieringAndOperator] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.IntelligentTieringFilter = {
    import IntelligentTieringFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.IntelligentTieringFilter
      .builder()
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(tag.map(value => value.buildAwsValue()))(_.tag)
      .optionallyWith(and.map(value => value.buildAwsValue()))(_.and)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.IntelligentTieringFilter.ReadOnly =
    zio.aws.s3.model.IntelligentTieringFilter.wrap(buildAwsValue())
}
object IntelligentTieringFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.IntelligentTieringFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.IntelligentTieringFilter =
      zio.aws.s3.model.IntelligentTieringFilter(
        prefix.map(value => value),
        tag.map(value => value.asEditable),
        and.map(value => value.asEditable)
      )
    def prefix: Optional[Prefix]
    def tag: Optional[zio.aws.s3.model.Tag.ReadOnly]
    def and: Optional[zio.aws.s3.model.IntelligentTieringAndOperator.ReadOnly]
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getTag: ZIO[Any, AwsError, zio.aws.s3.model.Tag.ReadOnly] =
      AwsError.unwrapOptionField("tag", tag)
    def getAnd: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.IntelligentTieringAndOperator.ReadOnly
    ] = AwsError.unwrapOptionField("and", and)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.IntelligentTieringFilter
  ) extends zio.aws.s3.model.IntelligentTieringFilter.ReadOnly {
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val tag: Optional[zio.aws.s3.model.Tag.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tag())
        .map(value => zio.aws.s3.model.Tag.wrap(value))
    override val and
        : Optional[zio.aws.s3.model.IntelligentTieringAndOperator.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.and())
        .map(value =>
          zio.aws.s3.model.IntelligentTieringAndOperator.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.IntelligentTieringFilter
  ): zio.aws.s3.model.IntelligentTieringFilter.ReadOnly = new Wrapper(impl)
}
