package zio.aws.s3.model
import scala.jdk.CollectionConverters._
sealed trait InventoryFormat {
  def unwrap: software.amazon.awssdk.services.s3.model.InventoryFormat
}
object InventoryFormat {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.InventoryFormat
  ): zio.aws.s3.model.InventoryFormat = value match {
    case software.amazon.awssdk.services.s3.model.InventoryFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.InventoryFormat.CSV =>
      val r = CSV
      r
    case software.amazon.awssdk.services.s3.model.InventoryFormat.ORC =>
      val r = ORC
      r
    case software.amazon.awssdk.services.s3.model.InventoryFormat.PARQUET =>
      val r = Parquet
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.InventoryFormat {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryFormat =
      software.amazon.awssdk.services.s3.model.InventoryFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object CSV extends zio.aws.s3.model.InventoryFormat {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryFormat =
      software.amazon.awssdk.services.s3.model.InventoryFormat.CSV
  }
  case object ORC extends zio.aws.s3.model.InventoryFormat {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryFormat =
      software.amazon.awssdk.services.s3.model.InventoryFormat.ORC
  }
  case object Parquet extends zio.aws.s3.model.InventoryFormat {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryFormat =
      software.amazon.awssdk.services.s3.model.InventoryFormat.PARQUET
  }
}
