package zio.aws.s3.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  MaxKeys,
  Token,
  Prefix,
  AccountId,
  FetchOwner,
  StartAfter,
  Delimiter,
  BucketName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListObjectsV2Request(
    bucket: BucketName,
    delimiter: Optional[Delimiter] = Optional.Absent,
    encodingType: Optional[zio.aws.s3.model.EncodingType] = Optional.Absent,
    maxKeys: Optional[MaxKeys] = Optional.Absent,
    prefix: Optional[Prefix] = Optional.Absent,
    continuationToken: Optional[Token] = Optional.Absent,
    fetchOwner: Optional[FetchOwner] = Optional.Absent,
    startAfter: Optional[StartAfter] = Optional.Absent,
    requestPayer: Optional[zio.aws.s3.model.RequestPayer] = Optional.Absent,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListObjectsV2Request = {
    import ListObjectsV2Request.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListObjectsV2Request
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        delimiter.map(value => Delimiter.unwrap(value): java.lang.String)
      )(_.delimiter)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .optionallyWith(maxKeys.map(value => MaxKeys.unwrap(value): Integer))(
        _.maxKeys
      )
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        continuationToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.continuationToken)
      .optionallyWith(
        fetchOwner.map(value => FetchOwner.unwrap(value): java.lang.Boolean)
      )(_.fetchOwner)
      .optionallyWith(
        startAfter.map(value => StartAfter.unwrap(value): java.lang.String)
      )(_.startAfter)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ListObjectsV2Request.ReadOnly =
    zio.aws.s3.model.ListObjectsV2Request.wrap(buildAwsValue())
}
object ListObjectsV2Request {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListObjectsV2Request
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListObjectsV2Request =
      zio.aws.s3.model.ListObjectsV2Request(
        bucket,
        delimiter.map(value => value),
        encodingType.map(value => value),
        maxKeys.map(value => value),
        prefix.map(value => value),
        continuationToken.map(value => value),
        fetchOwner.map(value => value),
        startAfter.map(value => value),
        requestPayer.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def delimiter: Optional[Delimiter]
    def encodingType: Optional[zio.aws.s3.model.EncodingType]
    def maxKeys: Optional[MaxKeys]
    def prefix: Optional[Prefix]
    def continuationToken: Optional[Token]
    def fetchOwner: Optional[FetchOwner]
    def startAfter: Optional[StartAfter]
    def requestPayer: Optional[zio.aws.s3.model.RequestPayer]
    def expectedBucketOwner: Optional[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getDelimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiter)
    def getEncodingType: ZIO[Any, AwsError, zio.aws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingType)
    def getMaxKeys: ZIO[Any, AwsError, MaxKeys] =
      AwsError.unwrapOptionField("maxKeys", maxKeys)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getContinuationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("continuationToken", continuationToken)
    def getFetchOwner: ZIO[Any, AwsError, FetchOwner] =
      AwsError.unwrapOptionField("fetchOwner", fetchOwner)
    def getStartAfter: ZIO[Any, AwsError, StartAfter] =
      AwsError.unwrapOptionField("startAfter", startAfter)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsV2Request
  ) extends zio.aws.s3.model.ListObjectsV2Request.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val delimiter: Optional[Delimiter] = zio.aws.core.internal
      .optionalFromNullable(impl.delimiter())
      .map(value => zio.aws.s3.model.primitives.Delimiter(value))
    override val encodingType: Optional[zio.aws.s3.model.EncodingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encodingType())
        .map(value => zio.aws.s3.model.EncodingType.wrap(value))
    override val maxKeys: Optional[MaxKeys] = zio.aws.core.internal
      .optionalFromNullable(impl.maxKeys())
      .map(value => zio.aws.s3.model.primitives.MaxKeys(value))
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val continuationToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.continuationToken())
      .map(value => zio.aws.s3.model.primitives.Token(value))
    override val fetchOwner: Optional[FetchOwner] = zio.aws.core.internal
      .optionalFromNullable(impl.fetchOwner())
      .map(value => zio.aws.s3.model.primitives.FetchOwner(value))
    override val startAfter: Optional[StartAfter] = zio.aws.core.internal
      .optionalFromNullable(impl.startAfter())
      .map(value => zio.aws.s3.model.primitives.StartAfter(value))
    override val requestPayer: Optional[zio.aws.s3.model.RequestPayer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestPayer())
        .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsV2Request
  ): zio.aws.s3.model.ListObjectsV2Request.ReadOnly = new Wrapper(impl)
}
