package zio.aws.s3.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  SSECustomerKey,
  MaxParts,
  AccountId,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  ObjectKey,
  BucketName,
  MultipartUploadId,
  PartNumberMarker
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPartsRequest(
    bucket: BucketName,
    key: ObjectKey,
    maxParts: Optional[MaxParts] = Optional.Absent,
    partNumberMarker: Optional[PartNumberMarker] = Optional.Absent,
    uploadId: MultipartUploadId,
    requestPayer: Optional[zio.aws.s3.model.RequestPayer] = Optional.Absent,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent,
    sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] = Optional.Absent,
    sseCustomerKey: Optional[SSECustomerKey] = Optional.Absent,
    sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListPartsRequest = {
    import ListPartsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListPartsRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .optionallyWith(maxParts.map(value => MaxParts.unwrap(value): Integer))(
        _.maxParts
      )
      .optionallyWith(
        partNumberMarker.map(value => PartNumberMarker.unwrap(value): Integer)
      )(_.partNumberMarker)
      .uploadId(MultipartUploadId.unwrap(uploadId): java.lang.String)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKey.map(value =>
          SSECustomerKey.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKey)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ListPartsRequest.ReadOnly =
    zio.aws.s3.model.ListPartsRequest.wrap(buildAwsValue())
}
object ListPartsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListPartsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListPartsRequest =
      zio.aws.s3.model.ListPartsRequest(
        bucket,
        key,
        maxParts.map(value => value),
        partNumberMarker.map(value => value),
        uploadId,
        requestPayer.map(value => value),
        expectedBucketOwner.map(value => value),
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKey.map(value => value),
        sseCustomerKeyMD5.map(value => value)
      )
    def bucket: BucketName
    def key: ObjectKey
    def maxParts: Optional[MaxParts]
    def partNumberMarker: Optional[PartNumberMarker]
    def uploadId: MultipartUploadId
    def requestPayer: Optional[zio.aws.s3.model.RequestPayer]
    def expectedBucketOwner: Optional[AccountId]
    def sseCustomerAlgorithm: Optional[SSECustomerAlgorithm]
    def sseCustomerKey: Optional[SSECustomerKey]
    def sseCustomerKeyMD5: Optional[SSECustomerKeyMD5]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getMaxParts: ZIO[Any, AwsError, MaxParts] =
      AwsError.unwrapOptionField("maxParts", maxParts)
    def getPartNumberMarker: ZIO[Any, AwsError, PartNumberMarker] =
      AwsError.unwrapOptionField("partNumberMarker", partNumberMarker)
    def getUploadId: ZIO[Any, Nothing, MultipartUploadId] =
      ZIO.succeed(uploadId)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKey)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListPartsRequest
  ) extends zio.aws.s3.model.ListPartsRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val maxParts: Optional[MaxParts] = zio.aws.core.internal
      .optionalFromNullable(impl.maxParts())
      .map(value => zio.aws.s3.model.primitives.MaxParts(value))
    override val partNumberMarker: Optional[PartNumberMarker] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partNumberMarker())
        .map(value => zio.aws.s3.model.primitives.PartNumberMarker(value))
    override val uploadId: MultipartUploadId =
      zio.aws.s3.model.primitives.MultipartUploadId(impl.uploadId())
    override val requestPayer: Optional[zio.aws.s3.model.RequestPayer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestPayer())
        .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
    override val sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerAlgorithm())
        .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKey: Optional[SSECustomerKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKey())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKey(value))
    override val sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKeyMD5())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListPartsRequest
  ): zio.aws.s3.model.ListPartsRequest.ReadOnly = new Wrapper(impl)
}
