package zio.aws.s3.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  MaxParts,
  AbortRuleId,
  NextPartNumberMarker,
  ObjectKey,
  BucketName,
  AbortDate,
  MultipartUploadId,
  PartNumberMarker,
  IsTruncated
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPartsResponse(
    abortDate: Optional[AbortDate] = Optional.Absent,
    abortRuleId: Optional[AbortRuleId] = Optional.Absent,
    bucket: Optional[BucketName] = Optional.Absent,
    key: Optional[ObjectKey] = Optional.Absent,
    uploadId: Optional[MultipartUploadId] = Optional.Absent,
    partNumberMarker: Optional[PartNumberMarker] = Optional.Absent,
    nextPartNumberMarker: Optional[NextPartNumberMarker] = Optional.Absent,
    maxParts: Optional[MaxParts] = Optional.Absent,
    isTruncated: Optional[IsTruncated] = Optional.Absent,
    parts: Optional[Iterable[zio.aws.s3.model.Part]] = Optional.Absent,
    initiator: Optional[zio.aws.s3.model.Initiator] = Optional.Absent,
    owner: Optional[zio.aws.s3.model.Owner] = Optional.Absent,
    storageClass: Optional[zio.aws.s3.model.StorageClass] = Optional.Absent,
    requestCharged: Optional[zio.aws.s3.model.RequestCharged] = Optional.Absent,
    checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListPartsResponse = {
    import ListPartsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListPartsResponse
      .builder()
      .optionallyWith(abortDate.map(value => AbortDate.unwrap(value): Instant))(
        _.abortDate
      )
      .optionallyWith(
        abortRuleId.map(value => AbortRuleId.unwrap(value): java.lang.String)
      )(_.abortRuleId)
      .optionallyWith(
        bucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        key.map(value => ObjectKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        uploadId.map(value => MultipartUploadId.unwrap(value): java.lang.String)
      )(_.uploadId)
      .optionallyWith(
        partNumberMarker.map(value => PartNumberMarker.unwrap(value): Integer)
      )(_.partNumberMarker)
      .optionallyWith(
        nextPartNumberMarker.map(value =>
          NextPartNumberMarker.unwrap(value): Integer
        )
      )(_.nextPartNumberMarker)
      .optionallyWith(maxParts.map(value => MaxParts.unwrap(value): Integer))(
        _.maxParts
      )
      .optionallyWith(
        isTruncated.map(value => IsTruncated.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        parts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parts)
      .optionallyWith(initiator.map(value => value.buildAwsValue()))(
        _.initiator
      )
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ListPartsResponse.ReadOnly =
    zio.aws.s3.model.ListPartsResponse.wrap(buildAwsValue())
}
object ListPartsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListPartsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListPartsResponse =
      zio.aws.s3.model.ListPartsResponse(
        abortDate.map(value => value),
        abortRuleId.map(value => value),
        bucket.map(value => value),
        key.map(value => value),
        uploadId.map(value => value),
        partNumberMarker.map(value => value),
        nextPartNumberMarker.map(value => value),
        maxParts.map(value => value),
        isTruncated.map(value => value),
        parts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        initiator.map(value => value.asEditable),
        owner.map(value => value.asEditable),
        storageClass.map(value => value),
        requestCharged.map(value => value),
        checksumAlgorithm.map(value => value)
      )
    def abortDate: Optional[AbortDate]
    def abortRuleId: Optional[AbortRuleId]
    def bucket: Optional[BucketName]
    def key: Optional[ObjectKey]
    def uploadId: Optional[MultipartUploadId]
    def partNumberMarker: Optional[PartNumberMarker]
    def nextPartNumberMarker: Optional[NextPartNumberMarker]
    def maxParts: Optional[MaxParts]
    def isTruncated: Optional[IsTruncated]
    def parts: Optional[List[zio.aws.s3.model.Part.ReadOnly]]
    def initiator: Optional[zio.aws.s3.model.Initiator.ReadOnly]
    def owner: Optional[zio.aws.s3.model.Owner.ReadOnly]
    def storageClass: Optional[zio.aws.s3.model.StorageClass]
    def requestCharged: Optional[zio.aws.s3.model.RequestCharged]
    def checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm]
    def getAbortDate: ZIO[Any, AwsError, AbortDate] =
      AwsError.unwrapOptionField("abortDate", abortDate)
    def getAbortRuleId: ZIO[Any, AwsError, AbortRuleId] =
      AwsError.unwrapOptionField("abortRuleId", abortRuleId)
    def getBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKey: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", key)
    def getUploadId: ZIO[Any, AwsError, MultipartUploadId] =
      AwsError.unwrapOptionField("uploadId", uploadId)
    def getPartNumberMarker: ZIO[Any, AwsError, PartNumberMarker] =
      AwsError.unwrapOptionField("partNumberMarker", partNumberMarker)
    def getNextPartNumberMarker: ZIO[Any, AwsError, NextPartNumberMarker] =
      AwsError.unwrapOptionField("nextPartNumberMarker", nextPartNumberMarker)
    def getMaxParts: ZIO[Any, AwsError, MaxParts] =
      AwsError.unwrapOptionField("maxParts", maxParts)
    def getIsTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getParts: ZIO[Any, AwsError, List[zio.aws.s3.model.Part.ReadOnly]] =
      AwsError.unwrapOptionField("parts", parts)
    def getInitiator: ZIO[Any, AwsError, zio.aws.s3.model.Initiator.ReadOnly] =
      AwsError.unwrapOptionField("initiator", initiator)
    def getOwner: ZIO[Any, AwsError, zio.aws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", owner)
    def getStorageClass: ZIO[Any, AwsError, zio.aws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, zio.aws.s3.model.ChecksumAlgorithm] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListPartsResponse
  ) extends zio.aws.s3.model.ListPartsResponse.ReadOnly {
    override val abortDate: Optional[AbortDate] = zio.aws.core.internal
      .optionalFromNullable(impl.abortDate())
      .map(value => zio.aws.s3.model.primitives.AbortDate(value))
    override val abortRuleId: Optional[AbortRuleId] = zio.aws.core.internal
      .optionalFromNullable(impl.abortRuleId())
      .map(value => zio.aws.s3.model.primitives.AbortRuleId(value))
    override val bucket: Optional[BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.s3.model.primitives.BucketName(value))
    override val key: Optional[ObjectKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.s3.model.primitives.ObjectKey(value))
    override val uploadId: Optional[MultipartUploadId] = zio.aws.core.internal
      .optionalFromNullable(impl.uploadId())
      .map(value => zio.aws.s3.model.primitives.MultipartUploadId(value))
    override val partNumberMarker: Optional[PartNumberMarker] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partNumberMarker())
        .map(value => zio.aws.s3.model.primitives.PartNumberMarker(value))
    override val nextPartNumberMarker: Optional[NextPartNumberMarker] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextPartNumberMarker())
        .map(value => zio.aws.s3.model.primitives.NextPartNumberMarker(value))
    override val maxParts: Optional[MaxParts] = zio.aws.core.internal
      .optionalFromNullable(impl.maxParts())
      .map(value => zio.aws.s3.model.primitives.MaxParts(value))
    override val isTruncated: Optional[IsTruncated] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.s3.model.primitives.IsTruncated(value))
    override val parts: Optional[List[zio.aws.s3.model.Part.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.Part.wrap(item)
          }.toList
        )
    override val initiator: Optional[zio.aws.s3.model.Initiator.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initiator())
        .map(value => zio.aws.s3.model.Initiator.wrap(value))
    override val owner: Optional[zio.aws.s3.model.Owner.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => zio.aws.s3.model.Owner.wrap(value))
    override val storageClass: Optional[zio.aws.s3.model.StorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value => zio.aws.s3.model.StorageClass.wrap(value))
    override val requestCharged: Optional[zio.aws.s3.model.RequestCharged] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestCharged())
        .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
    override val checksumAlgorithm
        : Optional[zio.aws.s3.model.ChecksumAlgorithm] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumAlgorithm())
      .map(value => zio.aws.s3.model.ChecksumAlgorithm.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListPartsResponse
  ): zio.aws.s3.model.ListPartsResponse.ReadOnly = new Wrapper(impl)
}
