package zio.aws.s3.model
import scala.jdk.CollectionConverters._
sealed trait MetadataDirective {
  def unwrap: software.amazon.awssdk.services.s3.model.MetadataDirective
}
object MetadataDirective {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.MetadataDirective
  ): zio.aws.s3.model.MetadataDirective = value match {
    case software.amazon.awssdk.services.s3.model.MetadataDirective.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.MetadataDirective.COPY =>
      val r = COPY
      r
    case software.amazon.awssdk.services.s3.model.MetadataDirective.REPLACE =>
      val r = REPLACE
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.MetadataDirective {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.MetadataDirective =
      software.amazon.awssdk.services.s3.model.MetadataDirective.UNKNOWN_TO_SDK_VERSION
  }
  case object COPY extends zio.aws.s3.model.MetadataDirective {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.MetadataDirective =
      software.amazon.awssdk.services.s3.model.MetadataDirective.COPY
  }
  case object REPLACE extends zio.aws.s3.model.MetadataDirective {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.MetadataDirective =
      software.amazon.awssdk.services.s3.model.MetadataDirective.REPLACE
  }
}
