package zio.aws.s3.model
import scala.jdk.CollectionConverters._
sealed trait ObjectAttributes {
  def unwrap: software.amazon.awssdk.services.s3.model.ObjectAttributes
}
object ObjectAttributes {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.ObjectAttributes
  ): zio.aws.s3.model.ObjectAttributes = value match {
    case software.amazon.awssdk.services.s3.model.ObjectAttributes.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.ObjectAttributes.E_TAG =>
      val r = ETag
      r
    case software.amazon.awssdk.services.s3.model.ObjectAttributes.CHECKSUM =>
      val r = Checksum
      r
    case software.amazon.awssdk.services.s3.model.ObjectAttributes.OBJECT_PARTS =>
      val r = ObjectParts
      r
    case software.amazon.awssdk.services.s3.model.ObjectAttributes.STORAGE_CLASS =>
      val r = StorageClass
      r
    case software.amazon.awssdk.services.s3.model.ObjectAttributes.OBJECT_SIZE =>
      val r = ObjectSize
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.ObjectAttributes {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectAttributes =
      software.amazon.awssdk.services.s3.model.ObjectAttributes.UNKNOWN_TO_SDK_VERSION
  }
  case object ETag extends zio.aws.s3.model.ObjectAttributes {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectAttributes =
      software.amazon.awssdk.services.s3.model.ObjectAttributes.E_TAG
  }
  case object Checksum extends zio.aws.s3.model.ObjectAttributes {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectAttributes =
      software.amazon.awssdk.services.s3.model.ObjectAttributes.CHECKSUM
  }
  case object ObjectParts extends zio.aws.s3.model.ObjectAttributes {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectAttributes =
      software.amazon.awssdk.services.s3.model.ObjectAttributes.OBJECT_PARTS
  }
  case object StorageClass extends zio.aws.s3.model.ObjectAttributes {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectAttributes =
      software.amazon.awssdk.services.s3.model.ObjectAttributes.STORAGE_CLASS
  }
  case object ObjectSize extends zio.aws.s3.model.ObjectAttributes {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectAttributes =
      software.amazon.awssdk.services.s3.model.ObjectAttributes.OBJECT_SIZE
  }
}
