package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ObjectLockConfiguration(
    objectLockEnabled: Optional[zio.aws.s3.model.ObjectLockEnabled] =
      Optional.Absent,
    rule: Optional[zio.aws.s3.model.ObjectLockRule] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ObjectLockConfiguration = {
    import ObjectLockConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ObjectLockConfiguration
      .builder()
      .optionallyWith(objectLockEnabled.map(value => value.unwrap))(
        _.objectLockEnabled
      )
      .optionallyWith(rule.map(value => value.buildAwsValue()))(_.rule)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ObjectLockConfiguration.ReadOnly =
    zio.aws.s3.model.ObjectLockConfiguration.wrap(buildAwsValue())
}
object ObjectLockConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ObjectLockConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ObjectLockConfiguration =
      zio.aws.s3.model.ObjectLockConfiguration(
        objectLockEnabled.map(value => value),
        rule.map(value => value.asEditable)
      )
    def objectLockEnabled: Optional[zio.aws.s3.model.ObjectLockEnabled]
    def rule: Optional[zio.aws.s3.model.ObjectLockRule.ReadOnly]
    def getObjectLockEnabled
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockEnabled] =
      AwsError.unwrapOptionField("objectLockEnabled", objectLockEnabled)
    def getRule: ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockRule.ReadOnly] =
      AwsError.unwrapOptionField("rule", rule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ObjectLockConfiguration
  ) extends zio.aws.s3.model.ObjectLockConfiguration.ReadOnly {
    override val objectLockEnabled
        : Optional[zio.aws.s3.model.ObjectLockEnabled] = zio.aws.core.internal
      .optionalFromNullable(impl.objectLockEnabled())
      .map(value => zio.aws.s3.model.ObjectLockEnabled.wrap(value))
    override val rule: Optional[zio.aws.s3.model.ObjectLockRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rule())
        .map(value => zio.aws.s3.model.ObjectLockRule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ObjectLockConfiguration
  ): zio.aws.s3.model.ObjectLockConfiguration.ReadOnly = new Wrapper(impl)
}
