package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ObjectLockRule(
    defaultRetention: Optional[zio.aws.s3.model.DefaultRetention] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ObjectLockRule = {
    import ObjectLockRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ObjectLockRule
      .builder()
      .optionallyWith(defaultRetention.map(value => value.buildAwsValue()))(
        _.defaultRetention
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ObjectLockRule.ReadOnly =
    zio.aws.s3.model.ObjectLockRule.wrap(buildAwsValue())
}
object ObjectLockRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.ObjectLockRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ObjectLockRule = zio.aws.s3.model
      .ObjectLockRule(defaultRetention.map(value => value.asEditable))
    def defaultRetention: Optional[zio.aws.s3.model.DefaultRetention.ReadOnly]
    def getDefaultRetention
        : ZIO[Any, AwsError, zio.aws.s3.model.DefaultRetention.ReadOnly] =
      AwsError.unwrapOptionField("defaultRetention", defaultRetention)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ObjectLockRule
  ) extends zio.aws.s3.model.ObjectLockRule.ReadOnly {
    override val defaultRetention
        : Optional[zio.aws.s3.model.DefaultRetention.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultRetention())
        .map(value => zio.aws.s3.model.DefaultRetention.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ObjectLockRule
  ): zio.aws.s3.model.ObjectLockRule.ReadOnly = new Wrapper(impl)
}
