package zio.aws.s3.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  ChecksumSHA256,
  ChecksumCRC32C,
  ChecksumCRC32,
  Size,
  ChecksumSHA1,
  PartNumber
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ObjectPart(
    partNumber: Optional[PartNumber] = Optional.Absent,
    size: Optional[Size] = Optional.Absent,
    checksumCRC32: Optional[ChecksumCRC32] = Optional.Absent,
    checksumCRC32C: Optional[ChecksumCRC32C] = Optional.Absent,
    checksumSHA1: Optional[ChecksumSHA1] = Optional.Absent,
    checksumSHA256: Optional[ChecksumSHA256] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.ObjectPart = {
    import ObjectPart.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ObjectPart
      .builder()
      .optionallyWith(
        partNumber.map(value => PartNumber.unwrap(value): Integer)
      )(_.partNumber)
      .optionallyWith(size.map(value => Size.unwrap(value): Integer))(_.size)
      .optionallyWith(
        checksumCRC32.map(value =>
          ChecksumCRC32.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32)
      .optionallyWith(
        checksumCRC32C.map(value =>
          ChecksumCRC32C.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32C)
      .optionallyWith(
        checksumSHA1.map(value => ChecksumSHA1.unwrap(value): java.lang.String)
      )(_.checksumSHA1)
      .optionallyWith(
        checksumSHA256.map(value =>
          ChecksumSHA256.unwrap(value): java.lang.String
        )
      )(_.checksumSHA256)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ObjectPart.ReadOnly =
    zio.aws.s3.model.ObjectPart.wrap(buildAwsValue())
}
object ObjectPart {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.ObjectPart] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ObjectPart = zio.aws.s3.model.ObjectPart(
      partNumber.map(value => value),
      size.map(value => value),
      checksumCRC32.map(value => value),
      checksumCRC32C.map(value => value),
      checksumSHA1.map(value => value),
      checksumSHA256.map(value => value)
    )
    def partNumber: Optional[PartNumber]
    def size: Optional[Size]
    def checksumCRC32: Optional[ChecksumCRC32]
    def checksumCRC32C: Optional[ChecksumCRC32C]
    def checksumSHA1: Optional[ChecksumSHA1]
    def checksumSHA256: Optional[ChecksumSHA256]
    def getPartNumber: ZIO[Any, AwsError, PartNumber] =
      AwsError.unwrapOptionField("partNumber", partNumber)
    def getSize: ZIO[Any, AwsError, Size] =
      AwsError.unwrapOptionField("size", size)
    def getChecksumCRC32: ZIO[Any, AwsError, ChecksumCRC32] =
      AwsError.unwrapOptionField("checksumCRC32", checksumCRC32)
    def getChecksumCRC32C: ZIO[Any, AwsError, ChecksumCRC32C] =
      AwsError.unwrapOptionField("checksumCRC32C", checksumCRC32C)
    def getChecksumSHA1: ZIO[Any, AwsError, ChecksumSHA1] =
      AwsError.unwrapOptionField("checksumSHA1", checksumSHA1)
    def getChecksumSHA256: ZIO[Any, AwsError, ChecksumSHA256] =
      AwsError.unwrapOptionField("checksumSHA256", checksumSHA256)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ObjectPart
  ) extends zio.aws.s3.model.ObjectPart.ReadOnly {
    override val partNumber: Optional[PartNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.partNumber())
      .map(value => zio.aws.s3.model.primitives.PartNumber(value))
    override val size: Optional[Size] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => zio.aws.s3.model.primitives.Size(value))
    override val checksumCRC32: Optional[ChecksumCRC32] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumCRC32())
      .map(value => zio.aws.s3.model.primitives.ChecksumCRC32(value))
    override val checksumCRC32C: Optional[ChecksumCRC32C] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checksumCRC32C())
        .map(value => zio.aws.s3.model.primitives.ChecksumCRC32C(value))
    override val checksumSHA1: Optional[ChecksumSHA1] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumSHA1())
      .map(value => zio.aws.s3.model.primitives.ChecksumSHA1(value))
    override val checksumSHA256: Optional[ChecksumSHA256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checksumSHA256())
        .map(value => zio.aws.s3.model.primitives.ChecksumSHA256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ObjectPart
  ): zio.aws.s3.model.ObjectPart.ReadOnly = new Wrapper(impl)
}
