package zio.aws.s3.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  ETag,
  IsLatest,
  LastModified,
  ObjectKey,
  ObjectVersionId
}
import scala.jdk.CollectionConverters._
final case class ObjectVersion(
    eTag: Optional[ETag] = Optional.Absent,
    checksumAlgorithm: Optional[Iterable[zio.aws.s3.model.ChecksumAlgorithm]] =
      Optional.Absent,
    size: Optional[Long] = Optional.Absent,
    storageClass: Optional[zio.aws.s3.model.ObjectVersionStorageClass] =
      Optional.Absent,
    key: Optional[ObjectKey] = Optional.Absent,
    versionId: Optional[ObjectVersionId] = Optional.Absent,
    isLatest: Optional[IsLatest] = Optional.Absent,
    lastModified: Optional[LastModified] = Optional.Absent,
    owner: Optional[zio.aws.s3.model.Owner] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ObjectVersion = {
    import ObjectVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ObjectVersion
      .builder()
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(
        checksumAlgorithm.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.checksumAlgorithmWithStrings)
      .optionallyWith(size.map(value => value: java.lang.Long))(_.size)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(
        key.map(value => ObjectKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        isLatest.map(value => IsLatest.unwrap(value): java.lang.Boolean)
      )(_.isLatest)
      .optionallyWith(
        lastModified.map(value => LastModified.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ObjectVersion.ReadOnly =
    zio.aws.s3.model.ObjectVersion.wrap(buildAwsValue())
}
object ObjectVersion {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.ObjectVersion] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ObjectVersion =
      zio.aws.s3.model.ObjectVersion(
        eTag.map(value => value),
        checksumAlgorithm.map(value => value),
        size.map(value => value),
        storageClass.map(value => value),
        key.map(value => value),
        versionId.map(value => value),
        isLatest.map(value => value),
        lastModified.map(value => value),
        owner.map(value => value.asEditable)
      )
    def eTag: Optional[ETag]
    def checksumAlgorithm: Optional[List[zio.aws.s3.model.ChecksumAlgorithm]]
    def size: Optional[Long]
    def storageClass: Optional[zio.aws.s3.model.ObjectVersionStorageClass]
    def key: Optional[ObjectKey]
    def versionId: Optional[ObjectVersionId]
    def isLatest: Optional[IsLatest]
    def lastModified: Optional[LastModified]
    def owner: Optional[zio.aws.s3.model.Owner.ReadOnly]
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, List[zio.aws.s3.model.ChecksumAlgorithm]] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
    def getSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("size", size)
    def getStorageClass
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectVersionStorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getKey: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", key)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getIsLatest: ZIO[Any, AwsError, IsLatest] =
      AwsError.unwrapOptionField("isLatest", isLatest)
    def getLastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getOwner: ZIO[Any, AwsError, zio.aws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", owner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ObjectVersion
  ) extends zio.aws.s3.model.ObjectVersion.ReadOnly {
    override val eTag: Optional[ETag] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => zio.aws.s3.model.primitives.ETag(value))
    override val checksumAlgorithm
        : Optional[List[zio.aws.s3.model.ChecksumAlgorithm]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checksumAlgorithm())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.ChecksumAlgorithm.wrap(item)
          }.toList
        )
    override val size: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => value: Long)
    override val storageClass
        : Optional[zio.aws.s3.model.ObjectVersionStorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value => zio.aws.s3.model.ObjectVersionStorageClass.wrap(value))
    override val key: Optional[ObjectKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.s3.model.primitives.ObjectKey(value))
    override val versionId: Optional[ObjectVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val isLatest: Optional[IsLatest] = zio.aws.core.internal
      .optionalFromNullable(impl.isLatest())
      .map(value => zio.aws.s3.model.primitives.IsLatest(value))
    override val lastModified: Optional[LastModified] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.s3.model.primitives.LastModified(value))
    override val owner: Optional[zio.aws.s3.model.Owner.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => zio.aws.s3.model.Owner.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ObjectVersion
  ): zio.aws.s3.model.ObjectVersion.ReadOnly = new Wrapper(impl)
}
