package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OutputLocation(
    s3: Optional[zio.aws.s3.model.S3Location] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.OutputLocation = {
    import OutputLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.OutputLocation
      .builder()
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.OutputLocation.ReadOnly =
    zio.aws.s3.model.OutputLocation.wrap(buildAwsValue())
}
object OutputLocation {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.OutputLocation] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.OutputLocation =
      zio.aws.s3.model.OutputLocation(s3.map(value => value.asEditable))
    def s3: Optional[zio.aws.s3.model.S3Location.ReadOnly]
    def getS3: ZIO[Any, AwsError, zio.aws.s3.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("s3", s3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.OutputLocation
  ) extends zio.aws.s3.model.OutputLocation.ReadOnly {
    override val s3: Optional[zio.aws.s3.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3())
        .map(value => zio.aws.s3.model.S3Location.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.OutputLocation
  ): zio.aws.s3.model.OutputLocation.ReadOnly = new Wrapper(impl)
}
