package zio.aws.s3.model
import zio.aws.s3.model.primitives.{ID, DisplayName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Owner(
    displayName: Optional[DisplayName] = Optional.Absent,
    id: Optional[ID] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Owner = {
    import Owner.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Owner
      .builder()
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(id.map(value => ID.unwrap(value): java.lang.String))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.Owner.ReadOnly =
    zio.aws.s3.model.Owner.wrap(buildAwsValue())
}
object Owner {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Owner] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.Owner = zio.aws.s3.model
      .Owner(displayName.map(value => value), id.map(value => value))
    def displayName: Optional[DisplayName]
    def id: Optional[ID]
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getId: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Owner
  ) extends zio.aws.s3.model.Owner.ReadOnly {
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.s3.model.primitives.DisplayName(value))
    override val id: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.s3.model.primitives.ID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Owner
  ): zio.aws.s3.model.Owner.ReadOnly = new Wrapper(impl)
}
