package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OwnershipControls(
    rules: Iterable[zio.aws.s3.model.OwnershipControlsRule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.OwnershipControls = {
    import OwnershipControls.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.OwnershipControls
      .builder()
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.OwnershipControls.ReadOnly =
    zio.aws.s3.model.OwnershipControls.wrap(buildAwsValue())
}
object OwnershipControls {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.OwnershipControls
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.OwnershipControls =
      zio.aws.s3.model.OwnershipControls(rules.map { item =>
        item.asEditable
      })
    def rules: List[zio.aws.s3.model.OwnershipControlsRule.ReadOnly]
    def getRules: ZIO[Any, Nothing, List[
      zio.aws.s3.model.OwnershipControlsRule.ReadOnly
    ]] = ZIO.succeed(rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.OwnershipControls
  ) extends zio.aws.s3.model.OwnershipControls.ReadOnly {
    override val rules: List[zio.aws.s3.model.OwnershipControlsRule.ReadOnly] =
      impl
        .rules()
        .asScala
        .map { item =>
          zio.aws.s3.model.OwnershipControlsRule.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.OwnershipControls
  ): zio.aws.s3.model.OwnershipControls.ReadOnly = new Wrapper(impl)
}
