package zio.aws.s3.model
import zio.aws.s3.model.primitives.{IntelligentTieringId, BucketName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutBucketIntelligentTieringConfigurationRequest(
    bucket: BucketName,
    id: IntelligentTieringId,
    intelligentTieringConfiguration: zio.aws.s3.model.IntelligentTieringConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketIntelligentTieringConfigurationRequest = {
    import PutBucketIntelligentTieringConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketIntelligentTieringConfigurationRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .id(IntelligentTieringId.unwrap(id): java.lang.String)
      .intelligentTieringConfiguration(
        intelligentTieringConfiguration.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.PutBucketIntelligentTieringConfigurationRequest.ReadOnly =
    zio.aws.s3.model.PutBucketIntelligentTieringConfigurationRequest
      .wrap(buildAwsValue())
}
object PutBucketIntelligentTieringConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketIntelligentTieringConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3.model.PutBucketIntelligentTieringConfigurationRequest =
      zio.aws.s3.model.PutBucketIntelligentTieringConfigurationRequest(
        bucket,
        id,
        intelligentTieringConfiguration.asEditable
      )
    def bucket: BucketName
    def id: IntelligentTieringId
    def intelligentTieringConfiguration
        : zio.aws.s3.model.IntelligentTieringConfiguration.ReadOnly
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getId: ZIO[Any, Nothing, IntelligentTieringId] = ZIO.succeed(id)
    def getIntelligentTieringConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.s3.model.IntelligentTieringConfiguration.ReadOnly
    ] = ZIO.succeed(intelligentTieringConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketIntelligentTieringConfigurationRequest
  ) extends zio.aws.s3.model.PutBucketIntelligentTieringConfigurationRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val id: IntelligentTieringId =
      zio.aws.s3.model.primitives.IntelligentTieringId(impl.id())
    override val intelligentTieringConfiguration
        : zio.aws.s3.model.IntelligentTieringConfiguration.ReadOnly =
      zio.aws.s3.model.IntelligentTieringConfiguration
        .wrap(impl.intelligentTieringConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketIntelligentTieringConfigurationRequest
  ): zio.aws.s3.model.PutBucketIntelligentTieringConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
