package zio.aws.s3.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  SSECustomerKey,
  ContentType,
  CacheControl,
  ContentMD5,
  WebsiteRedirectLocation,
  GrantRead,
  ContentDisposition,
  ContentLanguage,
  GrantReadACP,
  ContentLength,
  AccountId,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  SSEKMSEncryptionContext,
  ChecksumSHA256,
  Expires,
  ContentEncoding,
  ChecksumCRC32C,
  ObjectKey,
  GrantWriteACP,
  ChecksumCRC32,
  ChecksumSHA1,
  GrantFullControl,
  BucketName,
  SSEKMSKeyId,
  MetadataValue,
  TaggingHeader,
  ObjectLockRetainUntilDate,
  MetadataKey,
  BucketKeyEnabled
}
import scala.jdk.CollectionConverters._
final case class PutObjectRequest(
    acl: Optional[zio.aws.s3.model.ObjectCannedACL] = Optional.Absent,
    bucket: BucketName,
    cacheControl: Optional[CacheControl] = Optional.Absent,
    contentDisposition: Optional[ContentDisposition] = Optional.Absent,
    contentEncoding: Optional[ContentEncoding] = Optional.Absent,
    contentLanguage: Optional[ContentLanguage] = Optional.Absent,
    contentLength: Optional[ContentLength] = Optional.Absent,
    contentMD5: Optional[ContentMD5] = Optional.Absent,
    contentType: Optional[ContentType] = Optional.Absent,
    checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm] =
      Optional.Absent,
    checksumCRC32: Optional[ChecksumCRC32] = Optional.Absent,
    checksumCRC32C: Optional[ChecksumCRC32C] = Optional.Absent,
    checksumSHA1: Optional[ChecksumSHA1] = Optional.Absent,
    checksumSHA256: Optional[ChecksumSHA256] = Optional.Absent,
    expires: Optional[Expires] = Optional.Absent,
    grantFullControl: Optional[GrantFullControl] = Optional.Absent,
    grantRead: Optional[GrantRead] = Optional.Absent,
    grantReadACP: Optional[GrantReadACP] = Optional.Absent,
    grantWriteACP: Optional[GrantWriteACP] = Optional.Absent,
    key: ObjectKey,
    metadata: Optional[Map[MetadataKey, MetadataValue]] = Optional.Absent,
    serverSideEncryption: Optional[zio.aws.s3.model.ServerSideEncryption] =
      Optional.Absent,
    storageClass: Optional[zio.aws.s3.model.StorageClass] = Optional.Absent,
    websiteRedirectLocation: Optional[WebsiteRedirectLocation] =
      Optional.Absent,
    sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] = Optional.Absent,
    sseCustomerKey: Optional[SSECustomerKey] = Optional.Absent,
    sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] = Optional.Absent,
    ssekmsKeyId: Optional[SSEKMSKeyId] = Optional.Absent,
    ssekmsEncryptionContext: Optional[SSEKMSEncryptionContext] =
      Optional.Absent,
    bucketKeyEnabled: Optional[BucketKeyEnabled] = Optional.Absent,
    requestPayer: Optional[zio.aws.s3.model.RequestPayer] = Optional.Absent,
    tagging: Optional[TaggingHeader] = Optional.Absent,
    objectLockMode: Optional[zio.aws.s3.model.ObjectLockMode] = Optional.Absent,
    objectLockRetainUntilDate: Optional[ObjectLockRetainUntilDate] =
      Optional.Absent,
    objectLockLegalHoldStatus: Optional[
      zio.aws.s3.model.ObjectLockLegalHoldStatus
    ] = Optional.Absent,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutObjectRequest = {
    import PutObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutObjectRequest
      .builder()
      .optionallyWith(acl.map(value => value.unwrap))(_.acl)
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        cacheControl.map(value => CacheControl.unwrap(value): java.lang.String)
      )(_.cacheControl)
      .optionallyWith(
        contentDisposition.map(value =>
          ContentDisposition.unwrap(value): java.lang.String
        )
      )(_.contentDisposition)
      .optionallyWith(
        contentEncoding.map(value =>
          ContentEncoding.unwrap(value): java.lang.String
        )
      )(_.contentEncoding)
      .optionallyWith(
        contentLanguage.map(value =>
          ContentLanguage.unwrap(value): java.lang.String
        )
      )(_.contentLanguage)
      .optionallyWith(
        contentLength.map(value => ContentLength.unwrap(value): java.lang.Long)
      )(_.contentLength)
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(
        checksumCRC32.map(value =>
          ChecksumCRC32.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32)
      .optionallyWith(
        checksumCRC32C.map(value =>
          ChecksumCRC32C.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32C)
      .optionallyWith(
        checksumSHA1.map(value => ChecksumSHA1.unwrap(value): java.lang.String)
      )(_.checksumSHA1)
      .optionallyWith(
        checksumSHA256.map(value =>
          ChecksumSHA256.unwrap(value): java.lang.String
        )
      )(_.checksumSHA256)
      .optionallyWith(expires.map(value => Expires.unwrap(value): Instant))(
        _.expires
      )
      .optionallyWith(
        grantFullControl.map(value =>
          GrantFullControl.unwrap(value): java.lang.String
        )
      )(_.grantFullControl)
      .optionallyWith(
        grantRead.map(value => GrantRead.unwrap(value): java.lang.String)
      )(_.grantRead)
      .optionallyWith(
        grantReadACP.map(value => GrantReadACP.unwrap(value): java.lang.String)
      )(_.grantReadACP)
      .optionallyWith(
        grantWriteACP.map(value =>
          GrantWriteACP.unwrap(value): java.lang.String
        )
      )(_.grantWriteACP)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (MetadataKey.unwrap(key): java.lang.String) -> (MetadataValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(
        websiteRedirectLocation.map(value =>
          WebsiteRedirectLocation.unwrap(value): java.lang.String
        )
      )(_.websiteRedirectLocation)
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKey.map(value =>
          SSECustomerKey.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKey)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(
        ssekmsKeyId.map(value => SSEKMSKeyId.unwrap(value): java.lang.String)
      )(_.ssekmsKeyId)
      .optionallyWith(
        ssekmsEncryptionContext.map(value =>
          SSEKMSEncryptionContext.unwrap(value): java.lang.String
        )
      )(_.ssekmsEncryptionContext)
      .optionallyWith(
        bucketKeyEnabled.map(value =>
          BucketKeyEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.bucketKeyEnabled)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        tagging.map(value => TaggingHeader.unwrap(value): java.lang.String)
      )(_.tagging)
      .optionallyWith(objectLockMode.map(value => value.unwrap))(
        _.objectLockMode
      )
      .optionallyWith(
        objectLockRetainUntilDate.map(value =>
          ObjectLockRetainUntilDate.unwrap(value): Instant
        )
      )(_.objectLockRetainUntilDate)
      .optionallyWith(objectLockLegalHoldStatus.map(value => value.unwrap))(
        _.objectLockLegalHoldStatus
      )
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutObjectRequest.ReadOnly =
    zio.aws.s3.model.PutObjectRequest.wrap(buildAwsValue())
}
object PutObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutObjectRequest =
      zio.aws.s3.model.PutObjectRequest(
        acl.map(value => value),
        bucket,
        cacheControl.map(value => value),
        contentDisposition.map(value => value),
        contentEncoding.map(value => value),
        contentLanguage.map(value => value),
        contentLength.map(value => value),
        contentMD5.map(value => value),
        contentType.map(value => value),
        checksumAlgorithm.map(value => value),
        checksumCRC32.map(value => value),
        checksumCRC32C.map(value => value),
        checksumSHA1.map(value => value),
        checksumSHA256.map(value => value),
        expires.map(value => value),
        grantFullControl.map(value => value),
        grantRead.map(value => value),
        grantReadACP.map(value => value),
        grantWriteACP.map(value => value),
        key,
        metadata.map(value => value),
        serverSideEncryption.map(value => value),
        storageClass.map(value => value),
        websiteRedirectLocation.map(value => value),
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKey.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        ssekmsKeyId.map(value => value),
        ssekmsEncryptionContext.map(value => value),
        bucketKeyEnabled.map(value => value),
        requestPayer.map(value => value),
        tagging.map(value => value),
        objectLockMode.map(value => value),
        objectLockRetainUntilDate.map(value => value),
        objectLockLegalHoldStatus.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def acl: Optional[zio.aws.s3.model.ObjectCannedACL]
    def bucket: BucketName
    def cacheControl: Optional[CacheControl]
    def contentDisposition: Optional[ContentDisposition]
    def contentEncoding: Optional[ContentEncoding]
    def contentLanguage: Optional[ContentLanguage]
    def contentLength: Optional[ContentLength]
    def contentMD5: Optional[ContentMD5]
    def contentType: Optional[ContentType]
    def checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm]
    def checksumCRC32: Optional[ChecksumCRC32]
    def checksumCRC32C: Optional[ChecksumCRC32C]
    def checksumSHA1: Optional[ChecksumSHA1]
    def checksumSHA256: Optional[ChecksumSHA256]
    def expires: Optional[Expires]
    def grantFullControl: Optional[GrantFullControl]
    def grantRead: Optional[GrantRead]
    def grantReadACP: Optional[GrantReadACP]
    def grantWriteACP: Optional[GrantWriteACP]
    def key: ObjectKey
    def metadata: Optional[Map[MetadataKey, MetadataValue]]
    def serverSideEncryption: Optional[zio.aws.s3.model.ServerSideEncryption]
    def storageClass: Optional[zio.aws.s3.model.StorageClass]
    def websiteRedirectLocation: Optional[WebsiteRedirectLocation]
    def sseCustomerAlgorithm: Optional[SSECustomerAlgorithm]
    def sseCustomerKey: Optional[SSECustomerKey]
    def sseCustomerKeyMD5: Optional[SSECustomerKeyMD5]
    def ssekmsKeyId: Optional[SSEKMSKeyId]
    def ssekmsEncryptionContext: Optional[SSEKMSEncryptionContext]
    def bucketKeyEnabled: Optional[BucketKeyEnabled]
    def requestPayer: Optional[zio.aws.s3.model.RequestPayer]
    def tagging: Optional[TaggingHeader]
    def objectLockMode: Optional[zio.aws.s3.model.ObjectLockMode]
    def objectLockRetainUntilDate: Optional[ObjectLockRetainUntilDate]
    def objectLockLegalHoldStatus
        : Optional[zio.aws.s3.model.ObjectLockLegalHoldStatus]
    def expectedBucketOwner: Optional[AccountId]
    def getAcl: ZIO[Any, AwsError, zio.aws.s3.model.ObjectCannedACL] =
      AwsError.unwrapOptionField("acl", acl)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getCacheControl: ZIO[Any, AwsError, CacheControl] =
      AwsError.unwrapOptionField("cacheControl", cacheControl)
    def getContentDisposition: ZIO[Any, AwsError, ContentDisposition] =
      AwsError.unwrapOptionField("contentDisposition", contentDisposition)
    def getContentEncoding: ZIO[Any, AwsError, ContentEncoding] =
      AwsError.unwrapOptionField("contentEncoding", contentEncoding)
    def getContentLanguage: ZIO[Any, AwsError, ContentLanguage] =
      AwsError.unwrapOptionField("contentLanguage", contentLanguage)
    def getContentLength: ZIO[Any, AwsError, ContentLength] =
      AwsError.unwrapOptionField("contentLength", contentLength)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, zio.aws.s3.model.ChecksumAlgorithm] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
    def getChecksumCRC32: ZIO[Any, AwsError, ChecksumCRC32] =
      AwsError.unwrapOptionField("checksumCRC32", checksumCRC32)
    def getChecksumCRC32C: ZIO[Any, AwsError, ChecksumCRC32C] =
      AwsError.unwrapOptionField("checksumCRC32C", checksumCRC32C)
    def getChecksumSHA1: ZIO[Any, AwsError, ChecksumSHA1] =
      AwsError.unwrapOptionField("checksumSHA1", checksumSHA1)
    def getChecksumSHA256: ZIO[Any, AwsError, ChecksumSHA256] =
      AwsError.unwrapOptionField("checksumSHA256", checksumSHA256)
    def getExpires: ZIO[Any, AwsError, Expires] =
      AwsError.unwrapOptionField("expires", expires)
    def getGrantFullControl: ZIO[Any, AwsError, GrantFullControl] =
      AwsError.unwrapOptionField("grantFullControl", grantFullControl)
    def getGrantRead: ZIO[Any, AwsError, GrantRead] =
      AwsError.unwrapOptionField("grantRead", grantRead)
    def getGrantReadACP: ZIO[Any, AwsError, GrantReadACP] =
      AwsError.unwrapOptionField("grantReadACP", grantReadACP)
    def getGrantWriteACP: ZIO[Any, AwsError, GrantWriteACP] =
      AwsError.unwrapOptionField("grantWriteACP", grantWriteACP)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getMetadata: ZIO[Any, AwsError, Map[MetadataKey, MetadataValue]] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getServerSideEncryption
        : ZIO[Any, AwsError, zio.aws.s3.model.ServerSideEncryption] =
      AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getStorageClass: ZIO[Any, AwsError, zio.aws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getWebsiteRedirectLocation
        : ZIO[Any, AwsError, WebsiteRedirectLocation] = AwsError
      .unwrapOptionField("websiteRedirectLocation", websiteRedirectLocation)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKey)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getSsekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyId)
    def getSsekmsEncryptionContext
        : ZIO[Any, AwsError, SSEKMSEncryptionContext] = AwsError
      .unwrapOptionField("ssekmsEncryptionContext", ssekmsEncryptionContext)
    def getBucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabled)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getTagging: ZIO[Any, AwsError, TaggingHeader] =
      AwsError.unwrapOptionField("tagging", tagging)
    def getObjectLockMode: ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockMode] =
      AwsError.unwrapOptionField("objectLockMode", objectLockMode)
    def getObjectLockRetainUntilDate
        : ZIO[Any, AwsError, ObjectLockRetainUntilDate] = AwsError
      .unwrapOptionField("objectLockRetainUntilDate", objectLockRetainUntilDate)
    def getObjectLockLegalHoldStatus
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockLegalHoldStatus] =
      AwsError.unwrapOptionField(
        "objectLockLegalHoldStatus",
        objectLockLegalHoldStatus
      )
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutObjectRequest
  ) extends zio.aws.s3.model.PutObjectRequest.ReadOnly {
    override val acl: Optional[zio.aws.s3.model.ObjectCannedACL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acl())
        .map(value => zio.aws.s3.model.ObjectCannedACL.wrap(value))
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val cacheControl: Optional[CacheControl] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheControl())
      .map(value => zio.aws.s3.model.primitives.CacheControl(value))
    override val contentDisposition: Optional[ContentDisposition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentDisposition())
        .map(value => zio.aws.s3.model.primitives.ContentDisposition(value))
    override val contentEncoding: Optional[ContentEncoding] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentEncoding())
        .map(value => zio.aws.s3.model.primitives.ContentEncoding(value))
    override val contentLanguage: Optional[ContentLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentLanguage())
        .map(value => zio.aws.s3.model.primitives.ContentLanguage(value))
    override val contentLength: Optional[ContentLength] = zio.aws.core.internal
      .optionalFromNullable(impl.contentLength())
      .map(value => zio.aws.s3.model.primitives.ContentLength(value))
    override val contentMD5: Optional[ContentMD5] = zio.aws.core.internal
      .optionalFromNullable(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val contentType: Optional[ContentType] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => zio.aws.s3.model.primitives.ContentType(value))
    override val checksumAlgorithm
        : Optional[zio.aws.s3.model.ChecksumAlgorithm] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumAlgorithm())
      .map(value => zio.aws.s3.model.ChecksumAlgorithm.wrap(value))
    override val checksumCRC32: Optional[ChecksumCRC32] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumCRC32())
      .map(value => zio.aws.s3.model.primitives.ChecksumCRC32(value))
    override val checksumCRC32C: Optional[ChecksumCRC32C] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checksumCRC32C())
        .map(value => zio.aws.s3.model.primitives.ChecksumCRC32C(value))
    override val checksumSHA1: Optional[ChecksumSHA1] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumSHA1())
      .map(value => zio.aws.s3.model.primitives.ChecksumSHA1(value))
    override val checksumSHA256: Optional[ChecksumSHA256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checksumSHA256())
        .map(value => zio.aws.s3.model.primitives.ChecksumSHA256(value))
    override val expires: Optional[Expires] = zio.aws.core.internal
      .optionalFromNullable(impl.expires())
      .map(value => zio.aws.s3.model.primitives.Expires(value))
    override val grantFullControl: Optional[GrantFullControl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grantFullControl())
        .map(value => zio.aws.s3.model.primitives.GrantFullControl(value))
    override val grantRead: Optional[GrantRead] = zio.aws.core.internal
      .optionalFromNullable(impl.grantRead())
      .map(value => zio.aws.s3.model.primitives.GrantRead(value))
    override val grantReadACP: Optional[GrantReadACP] = zio.aws.core.internal
      .optionalFromNullable(impl.grantReadACP())
      .map(value => zio.aws.s3.model.primitives.GrantReadACP(value))
    override val grantWriteACP: Optional[GrantWriteACP] = zio.aws.core.internal
      .optionalFromNullable(impl.grantWriteACP())
      .map(value => zio.aws.s3.model.primitives.GrantWriteACP(value))
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val metadata: Optional[Map[MetadataKey, MetadataValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.s3.model.primitives.MetadataKey(
                key
              ) -> zio.aws.s3.model.primitives.MetadataValue(value)
            })
            .toMap
        )
    override val serverSideEncryption
        : Optional[zio.aws.s3.model.ServerSideEncryption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverSideEncryption())
        .map(value => zio.aws.s3.model.ServerSideEncryption.wrap(value))
    override val storageClass: Optional[zio.aws.s3.model.StorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value => zio.aws.s3.model.StorageClass.wrap(value))
    override val websiteRedirectLocation: Optional[WebsiteRedirectLocation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.websiteRedirectLocation())
        .map(value =>
          zio.aws.s3.model.primitives.WebsiteRedirectLocation(value)
        )
    override val sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerAlgorithm())
        .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKey: Optional[SSECustomerKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKey())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKey(value))
    override val sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKeyMD5())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val ssekmsKeyId: Optional[SSEKMSKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.ssekmsKeyId())
      .map(value => zio.aws.s3.model.primitives.SSEKMSKeyId(value))
    override val ssekmsEncryptionContext: Optional[SSEKMSEncryptionContext] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ssekmsEncryptionContext())
        .map(value =>
          zio.aws.s3.model.primitives.SSEKMSEncryptionContext(value)
        )
    override val bucketKeyEnabled: Optional[BucketKeyEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketKeyEnabled())
        .map(value => zio.aws.s3.model.primitives.BucketKeyEnabled(value))
    override val requestPayer: Optional[zio.aws.s3.model.RequestPayer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestPayer())
        .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val tagging: Optional[TaggingHeader] = zio.aws.core.internal
      .optionalFromNullable(impl.tagging())
      .map(value => zio.aws.s3.model.primitives.TaggingHeader(value))
    override val objectLockMode: Optional[zio.aws.s3.model.ObjectLockMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectLockMode())
        .map(value => zio.aws.s3.model.ObjectLockMode.wrap(value))
    override val objectLockRetainUntilDate
        : Optional[ObjectLockRetainUntilDate] = zio.aws.core.internal
      .optionalFromNullable(impl.objectLockRetainUntilDate())
      .map(value =>
        zio.aws.s3.model.primitives.ObjectLockRetainUntilDate(value)
      )
    override val objectLockLegalHoldStatus
        : Optional[zio.aws.s3.model.ObjectLockLegalHoldStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectLockLegalHoldStatus())
        .map(value => zio.aws.s3.model.ObjectLockLegalHoldStatus.wrap(value))
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutObjectRequest
  ): zio.aws.s3.model.PutObjectRequest.ReadOnly = new Wrapper(impl)
}
