package zio.aws.s3.model
import zio.aws.s3.model.primitives.ObjectVersionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutObjectTaggingResponse(
    versionId: Optional[ObjectVersionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutObjectTaggingResponse = {
    import PutObjectTaggingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutObjectTaggingResponse
      .builder()
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutObjectTaggingResponse.ReadOnly =
    zio.aws.s3.model.PutObjectTaggingResponse.wrap(buildAwsValue())
}
object PutObjectTaggingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutObjectTaggingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutObjectTaggingResponse =
      zio.aws.s3.model.PutObjectTaggingResponse(versionId.map(value => value))
    def versionId: Optional[ObjectVersionId]
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutObjectTaggingResponse
  ) extends zio.aws.s3.model.PutObjectTaggingResponse.ReadOnly {
    override val versionId: Optional[ObjectVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutObjectTaggingResponse
  ): zio.aws.s3.model.PutObjectTaggingResponse.ReadOnly = new Wrapper(impl)
}
