package zio.aws.s3.model
import scala.jdk.CollectionConverters._
sealed trait QuoteFields {
  def unwrap: software.amazon.awssdk.services.s3.model.QuoteFields
}
object QuoteFields {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.QuoteFields
  ): zio.aws.s3.model.QuoteFields = value match {
    case software.amazon.awssdk.services.s3.model.QuoteFields.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.QuoteFields.ALWAYS =>
      val r = ALWAYS
      r
    case software.amazon.awssdk.services.s3.model.QuoteFields.ASNEEDED =>
      val r = ASNEEDED
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.QuoteFields {
    override def unwrap: software.amazon.awssdk.services.s3.model.QuoteFields =
      software.amazon.awssdk.services.s3.model.QuoteFields.UNKNOWN_TO_SDK_VERSION
  }
  case object ALWAYS extends zio.aws.s3.model.QuoteFields {
    override def unwrap: software.amazon.awssdk.services.s3.model.QuoteFields =
      software.amazon.awssdk.services.s3.model.QuoteFields.ALWAYS
  }
  case object ASNEEDED extends zio.aws.s3.model.QuoteFields {
    override def unwrap: software.amazon.awssdk.services.s3.model.QuoteFields =
      software.amazon.awssdk.services.s3.model.QuoteFields.ASNEEDED
  }
}
