package zio.aws.s3.model
import zio.aws.s3.model.primitives.Body
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RecordsEvent(payload: Optional[Body] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.RecordsEvent = {
    import RecordsEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.RecordsEvent
      .builder()
      .optionallyWith(
        payload.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.payload)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.RecordsEvent.ReadOnly =
    zio.aws.s3.model.RecordsEvent.wrap(buildAwsValue())
}
object RecordsEvent {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.RecordsEvent] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.RecordsEvent =
      zio.aws.s3.model.RecordsEvent(payload.map(value => value))
    def payload: Optional[Body]
    def getPayload: ZIO[Any, AwsError, Body] =
      AwsError.unwrapOptionField("payload", payload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.RecordsEvent
  ) extends zio.aws.s3.model.RecordsEvent.ReadOnly {
    override val payload: Optional[Body] = zio.aws.core.internal
      .optionalFromNullable(impl.payload())
      .map(value =>
        zio.aws.s3.model.primitives
          .Body(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.RecordsEvent
  ): zio.aws.s3.model.RecordsEvent.ReadOnly = new Wrapper(impl)
}
